// Copyright 2017 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// THIS FILE IS AUTOMATICALLY GENERATED.

package openapi_v2

import (
	"fmt"
	"github.com/googleapis/gnostic/compiler"
	"gopkg.in/yaml.v2"
	"strings"
)

// Version returns the package name (and OpenAPI version).
func Version() string {
	return "openapi_v2"
}

// NewAdditionalPropertiesItem creates an object of type AdditionalPropertiesItem if possible, returning an error if not.
func NewAdditionalPropertiesItem(in interface{}, context *compiler.Context) (*AdditionalPropertiesItem, error) {
	errors := make([]error, 0)
	x := &AdditionalPropertiesItem{}
	matched := false
	// Schema schema = 1;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewSchema(m, compiler.NewContext("schema", context))
			if matchingError == nil {
				x.Oneof = &AdditionalPropertiesItem_Schema{Schema: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// bool boolean = 2;
	boolValue, ok := in.(bool)
	if ok {
		x.Oneof = &AdditionalPropertiesItem_Boolean{Boolean: boolValue}
	}
	if matched {
		// since the oneof matched one of its possibilities, discard any matching errors
		errors = make([]error, 0)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewAny creates an object of type Any if possible, returning an error if not.
func NewAny(in interface{}, context *compiler.Context) (*Any, error) {
	errors := make([]error, 0)
	x := &Any{}
	bytes, _ := yaml.Marshal(in)
	x.Yaml = string(bytes)
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewApiKeySecurity creates an object of type ApiKeySecurity if possible, returning an error if not.
func NewApiKeySecurity(in interface{}, context *compiler.Context) (*ApiKeySecurity, error) {
	errors := make([]error, 0)
	x := &ApiKeySecurity{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"in", "name", "type"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"description", "in", "name", "type"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string type = 1;
		v1 := compiler.MapValueForKey(m, "type")
		if v1 != nil {
			x.Type, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [apiKey]
			if ok && !compiler.StringArrayContainsValue([]string{"apiKey"}, x.Type) {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string name = 2;
		v2 := compiler.MapValueForKey(m, "name")
		if v2 != nil {
			x.Name, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string in = 3;
		v3 := compiler.MapValueForKey(m, "in")
		if v3 != nil {
			x.In, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for in: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [header query]
			if ok && !compiler.StringArrayContainsValue([]string{"header", "query"}, x.In) {
				message := fmt.Sprintf("has unexpected value for in: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 4;
		v4 := compiler.MapValueForKey(m, "description")
		if v4 != nil {
			x.Description, ok = v4.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny vendor_extension = 5;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewBasicAuthenticationSecurity creates an object of type BasicAuthenticationSecurity if possible, returning an error if not.
func NewBasicAuthenticationSecurity(in interface{}, context *compiler.Context) (*BasicAuthenticationSecurity, error) {
	errors := make([]error, 0)
	x := &BasicAuthenticationSecurity{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"type"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"description", "type"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string type = 1;
		v1 := compiler.MapValueForKey(m, "type")
		if v1 != nil {
			x.Type, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [basic]
			if ok && !compiler.StringArrayContainsValue([]string{"basic"}, x.Type) {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 2;
		v2 := compiler.MapValueForKey(m, "description")
		if v2 != nil {
			x.Description, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny vendor_extension = 3;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewBodyParameter creates an object of type BodyParameter if possible, returning an error if not.
func NewBodyParameter(in interface{}, context *compiler.Context) (*BodyParameter, error) {
	errors := make([]error, 0)
	x := &BodyParameter{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"in", "name", "schema"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"description", "in", "name", "required", "schema"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string description = 1;
		v1 := compiler.MapValueForKey(m, "description")
		if v1 != nil {
			x.Description, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string name = 2;
		v2 := compiler.MapValueForKey(m, "name")
		if v2 != nil {
			x.Name, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string in = 3;
		v3 := compiler.MapValueForKey(m, "in")
		if v3 != nil {
			x.In, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for in: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [body]
			if ok && !compiler.StringArrayContainsValue([]string{"body"}, x.In) {
				message := fmt.Sprintf("has unexpected value for in: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool required = 4;
		v4 := compiler.MapValueForKey(m, "required")
		if v4 != nil {
			x.Required, ok = v4.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for required: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Schema schema = 5;
		v5 := compiler.MapValueForKey(m, "schema")
		if v5 != nil {
			var err error
			x.Schema, err = NewSchema(v5, compiler.NewContext("schema", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated NamedAny vendor_extension = 6;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewContact creates an object of type Contact if possible, returning an error if not.
func NewContact(in interface{}, context *compiler.Context) (*Contact, error) {
	errors := make([]error, 0)
	x := &Contact{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"email", "name", "url"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string url = 2;
		v2 := compiler.MapValueForKey(m, "url")
		if v2 != nil {
			x.Url, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for url: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string email = 3;
		v3 := compiler.MapValueForKey(m, "email")
		if v3 != nil {
			x.Email, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for email: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny vendor_extension = 4;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewDefault creates an object of type Default if possible, returning an error if not.
func NewDefault(in interface{}, context *compiler.Context) (*Default, error) {
	errors := make([]error, 0)
	x := &Default{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedAny additional_properties = 1;
		// MAP: Any
		x.AdditionalProperties = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedAny{}
				pair.Name = k
				result := &Any{}
				handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
				if handled {
					if err != nil {
						errors = append(errors, err)
					} else {
						bytes, _ := yaml.Marshal(v)
						result.Yaml = string(bytes)
						result.Value = resultFromExt
						pair.Value = result
					}
				} else {
					pair.Value, err = NewAny(v, compiler.NewContext(k, context))
					if err != nil {
						errors = append(errors, err)
					}
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewDefinitions creates an object of type Definitions if possible, returning an error if not.
func NewDefinitions(in interface{}, context *compiler.Context) (*Definitions, error) {
	errors := make([]error, 0)
	x := &Definitions{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedSchema additional_properties = 1;
		// MAP: Schema
		x.AdditionalProperties = make([]*NamedSchema, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedSchema{}
				pair.Name = k
				var err error
				pair.Value, err = NewSchema(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewDocument creates an object of type Document if possible, returning an error if not.
func NewDocument(in interface{}, context *compiler.Context) (*Document, error) {
	errors := make([]error, 0)
	x := &Document{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"info", "paths", "swagger"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"basePath", "consumes", "definitions", "externalDocs", "host", "info", "parameters", "paths", "produces", "responses", "schemes", "security", "securityDefinitions", "swagger", "tags"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string swagger = 1;
		v1 := compiler.MapValueForKey(m, "swagger")
		if v1 != nil {
			x.Swagger, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for swagger: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [2.0]
			if ok && !compiler.StringArrayContainsValue([]string{"2.0"}, x.Swagger) {
				message := fmt.Sprintf("has unexpected value for swagger: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Info info = 2;
		v2 := compiler.MapValueForKey(m, "info")
		if v2 != nil {
			var err error
			x.Info, err = NewInfo(v2, compiler.NewContext("info", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string host = 3;
		v3 := compiler.MapValueForKey(m, "host")
		if v3 != nil {
			x.Host, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for host: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string base_path = 4;
		v4 := compiler.MapValueForKey(m, "basePath")
		if v4 != nil {
			x.BasePath, ok = v4.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for basePath: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated string schemes = 5;
		v5 := compiler.MapValueForKey(m, "schemes")
		if v5 != nil {
			v, ok := v5.([]interface{})
			if ok {
				x.Schemes = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for schemes: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [http https ws wss]
			if ok && !compiler.StringArrayContainsValues([]string{"http", "https", "ws", "wss"}, x.Schemes) {
				message := fmt.Sprintf("has unexpected value for schemes: %+v", v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated string consumes = 6;
		v6 := compiler.MapValueForKey(m, "consumes")
		if v6 != nil {
			v, ok := v6.([]interface{})
			if ok {
				x.Consumes = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for consumes: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated string produces = 7;
		v7 := compiler.MapValueForKey(m, "produces")
		if v7 != nil {
			v, ok := v7.([]interface{})
			if ok {
				x.Produces = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for produces: %+v (%T)", v7, v7)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Paths paths = 8;
		v8 := compiler.MapValueForKey(m, "paths")
		if v8 != nil {
			var err error
			x.Paths, err = NewPaths(v8, compiler.NewContext("paths", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Definitions definitions = 9;
		v9 := compiler.MapValueForKey(m, "definitions")
		if v9 != nil {
			var err error
			x.Definitions, err = NewDefinitions(v9, compiler.NewContext("definitions", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// ParameterDefinitions parameters = 10;
		v10 := compiler.MapValueForKey(m, "parameters")
		if v10 != nil {
			var err error
			x.Parameters, err = NewParameterDefinitions(v10, compiler.NewContext("parameters", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// ResponseDefinitions responses = 11;
		v11 := compiler.MapValueForKey(m, "responses")
		if v11 != nil {
			var err error
			x.Responses, err = NewResponseDefinitions(v11, compiler.NewContext("responses", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated SecurityRequirement security = 12;
		v12 := compiler.MapValueForKey(m, "security")
		if v12 != nil {
			// repeated SecurityRequirement
			x.Security = make([]*SecurityRequirement, 0)
			a, ok := v12.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewSecurityRequirement(item, compiler.NewContext("security", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Security = append(x.Security, y)
				}
			}
		}
		// SecurityDefinitions security_definitions = 13;
		v13 := compiler.MapValueForKey(m, "securityDefinitions")
		if v13 != nil {
			var err error
			x.SecurityDefinitions, err = NewSecurityDefinitions(v13, compiler.NewContext("securityDefinitions", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated Tag tags = 14;
		v14 := compiler.MapValueForKey(m, "tags")
		if v14 != nil {
			// repeated Tag
			x.Tags = make([]*Tag, 0)
			a, ok := v14.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewTag(item, compiler.NewContext("tags", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Tags = append(x.Tags, y)
				}
			}
		}
		// ExternalDocs external_docs = 15;
		v15 := compiler.MapValueForKey(m, "externalDocs")
		if v15 != nil {
			var err error
			x.ExternalDocs, err = NewExternalDocs(v15, compiler.NewContext("externalDocs", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated NamedAny vendor_extension = 16;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewExamples creates an object of type Examples if possible, returning an error if not.
func NewExamples(in interface{}, context *compiler.Context) (*Examples, error) {
	errors := make([]error, 0)
	x := &Examples{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedAny additional_properties = 1;
		// MAP: Any
		x.AdditionalProperties = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedAny{}
				pair.Name = k
				result := &Any{}
				handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
				if handled {
					if err != nil {
						errors = append(errors, err)
					} else {
						bytes, _ := yaml.Marshal(v)
						result.Yaml = string(bytes)
						result.Value = resultFromExt
						pair.Value = result
					}
				} else {
					pair.Value, err = NewAny(v, compiler.NewContext(k, context))
					if err != nil {
						errors = append(errors, err)
					}
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewExternalDocs creates an object of type ExternalDocs if possible, returning an error if not.
func NewExternalDocs(in interface{}, context *compiler.Context) (*ExternalDocs, error) {
	errors := make([]error, 0)
	x := &ExternalDocs{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"url"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"description", "url"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string description = 1;
		v1 := compiler.MapValueForKey(m, "description")
		if v1 != nil {
			x.Description, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string url = 2;
		v2 := compiler.MapValueForKey(m, "url")
		if v2 != nil {
			x.Url, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for url: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny vendor_extension = 3;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewFileSchema creates an object of type FileSchema if possible, returning an error if not.
func NewFileSchema(in interface{}, context *compiler.Context) (*FileSchema, error) {
	errors := make([]error, 0)
	x := &FileSchema{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"type"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"default", "description", "example", "externalDocs", "format", "readOnly", "required", "title", "type"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string format = 1;
		v1 := compiler.MapValueForKey(m, "format")
		if v1 != nil {
			x.Format, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for format: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string title = 2;
		v2 := compiler.MapValueForKey(m, "title")
		if v2 != nil {
			x.Title, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for title: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 3;
		v3 := compiler.MapValueForKey(m, "description")
		if v3 != nil {
			x.Description, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Any default = 4;
		v4 := compiler.MapValueForKey(m, "default")
		if v4 != nil {
			var err error
			x.Default, err = NewAny(v4, compiler.NewContext("default", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated string required = 5;
		v5 := compiler.MapValueForKey(m, "required")
		if v5 != nil {
			v, ok := v5.([]interface{})
			if ok {
				x.Required = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for required: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string type = 6;
		v6 := compiler.MapValueForKey(m, "type")
		if v6 != nil {
			x.Type, ok = v6.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [file]
			if ok && !compiler.StringArrayContainsValue([]string{"file"}, x.Type) {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool read_only = 7;
		v7 := compiler.MapValueForKey(m, "readOnly")
		if v7 != nil {
			x.ReadOnly, ok = v7.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for readOnly: %+v (%T)", v7, v7)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// ExternalDocs external_docs = 8;
		v8 := compiler.MapValueForKey(m, "externalDocs")
		if v8 != nil {
			var err error
			x.ExternalDocs, err = NewExternalDocs(v8, compiler.NewContext("externalDocs", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Any example = 9;
		v9 := compiler.MapValueForKey(m, "example")
		if v9 != nil {
			var err error
			x.Example, err = NewAny(v9, compiler.NewContext("example", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated NamedAny vendor_extension = 10;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewFormDataParameterSubSchema creates an object of type FormDataParameterSubSchema if possible, returning an error if not.
func NewFormDataParameterSubSchema(in interface{}, context *compiler.Context) (*FormDataParameterSubSchema, error) {
	errors := make([]error, 0)
	x := &FormDataParameterSubSchema{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"allowEmptyValue", "collectionFormat", "default", "description", "enum", "exclusiveMaximum", "exclusiveMinimum", "format", "in", "items", "maxItems", "maxLength", "maximum", "minItems", "minLength", "minimum", "multipleOf", "name", "pattern", "required", "type", "uniqueItems"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// bool required = 1;
		v1 := compiler.MapValueForKey(m, "required")
		if v1 != nil {
			x.Required, ok = v1.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for required: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string in = 2;
		v2 := compiler.MapValueForKey(m, "in")
		if v2 != nil {
			x.In, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for in: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [formData]
			if ok && !compiler.StringArrayContainsValue([]string{"formData"}, x.In) {
				message := fmt.Sprintf("has unexpected value for in: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 3;
		v3 := compiler.MapValueForKey(m, "description")
		if v3 != nil {
			x.Description, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string name = 4;
		v4 := compiler.MapValueForKey(m, "name")
		if v4 != nil {
			x.Name, ok = v4.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool allow_empty_value = 5;
		v5 := compiler.MapValueForKey(m, "allowEmptyValue")
		if v5 != nil {
			x.AllowEmptyValue, ok = v5.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for allowEmptyValue: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string type = 6;
		v6 := compiler.MapValueForKey(m, "type")
		if v6 != nil {
			x.Type, ok = v6.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [string number boolean integer array file]
			if ok && !compiler.StringArrayContainsValue([]string{"string", "number", "boolean", "integer", "array", "file"}, x.Type) {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string format = 7;
		v7 := compiler.MapValueForKey(m, "format")
		if v7 != nil {
			x.Format, ok = v7.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for format: %+v (%T)", v7, v7)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// PrimitivesItems items = 8;
		v8 := compiler.MapValueForKey(m, "items")
		if v8 != nil {
			var err error
			x.Items, err = NewPrimitivesItems(v8, compiler.NewContext("items", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string collection_format = 9;
		v9 := compiler.MapValueForKey(m, "collectionFormat")
		if v9 != nil {
			x.CollectionFormat, ok = v9.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for collectionFormat: %+v (%T)", v9, v9)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [csv ssv tsv pipes multi]
			if ok && !compiler.StringArrayContainsValue([]string{"csv", "ssv", "tsv", "pipes", "multi"}, x.CollectionFormat) {
				message := fmt.Sprintf("has unexpected value for collectionFormat: %+v (%T)", v9, v9)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Any default = 10;
		v10 := compiler.MapValueForKey(m, "default")
		if v10 != nil {
			var err error
			x.Default, err = NewAny(v10, compiler.NewContext("default", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// float maximum = 11;
		v11 := compiler.MapValueForKey(m, "maximum")
		if v11 != nil {
			switch v11 := v11.(type) {
			case float64:
				x.Maximum = v11
			case float32:
				x.Maximum = float64(v11)
			case uint64:
				x.Maximum = float64(v11)
			case uint32:
				x.Maximum = float64(v11)
			case int64:
				x.Maximum = float64(v11)
			case int32:
				x.Maximum = float64(v11)
			case int:
				x.Maximum = float64(v11)
			default:
				message := fmt.Sprintf("has unexpected value for maximum: %+v (%T)", v11, v11)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool exclusive_maximum = 12;
		v12 := compiler.MapValueForKey(m, "exclusiveMaximum")
		if v12 != nil {
			x.ExclusiveMaximum, ok = v12.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for exclusiveMaximum: %+v (%T)", v12, v12)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// float minimum = 13;
		v13 := compiler.MapValueForKey(m, "minimum")
		if v13 != nil {
			switch v13 := v13.(type) {
			case float64:
				x.Minimum = v13
			case float32:
				x.Minimum = float64(v13)
			case uint64:
				x.Minimum = float64(v13)
			case uint32:
				x.Minimum = float64(v13)
			case int64:
				x.Minimum = float64(v13)
			case int32:
				x.Minimum = float64(v13)
			case int:
				x.Minimum = float64(v13)
			default:
				message := fmt.Sprintf("has unexpected value for minimum: %+v (%T)", v13, v13)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool exclusive_minimum = 14;
		v14 := compiler.MapValueForKey(m, "exclusiveMinimum")
		if v14 != nil {
			x.ExclusiveMinimum, ok = v14.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for exclusiveMinimum: %+v (%T)", v14, v14)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 max_length = 15;
		v15 := compiler.MapValueForKey(m, "maxLength")
		if v15 != nil {
			t, ok := v15.(int)
			if ok {
				x.MaxLength = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for maxLength: %+v (%T)", v15, v15)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 min_length = 16;
		v16 := compiler.MapValueForKey(m, "minLength")
		if v16 != nil {
			t, ok := v16.(int)
			if ok {
				x.MinLength = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for minLength: %+v (%T)", v16, v16)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string pattern = 17;
		v17 := compiler.MapValueForKey(m, "pattern")
		if v17 != nil {
			x.Pattern, ok = v17.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for pattern: %+v (%T)", v17, v17)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 max_items = 18;
		v18 := compiler.MapValueForKey(m, "maxItems")
		if v18 != nil {
			t, ok := v18.(int)
			if ok {
				x.MaxItems = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for maxItems: %+v (%T)", v18, v18)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 min_items = 19;
		v19 := compiler.MapValueForKey(m, "minItems")
		if v19 != nil {
			t, ok := v19.(int)
			if ok {
				x.MinItems = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for minItems: %+v (%T)", v19, v19)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool unique_items = 20;
		v20 := compiler.MapValueForKey(m, "uniqueItems")
		if v20 != nil {
			x.UniqueItems, ok = v20.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for uniqueItems: %+v (%T)", v20, v20)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated Any enum = 21;
		v21 := compiler.MapValueForKey(m, "enum")
		if v21 != nil {
			// repeated Any
			x.Enum = make([]*Any, 0)
			a, ok := v21.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewAny(item, compiler.NewContext("enum", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Enum = append(x.Enum, y)
				}
			}
		}
		// float multiple_of = 22;
		v22 := compiler.MapValueForKey(m, "multipleOf")
		if v22 != nil {
			switch v22 := v22.(type) {
			case float64:
				x.MultipleOf = v22
			case float32:
				x.MultipleOf = float64(v22)
			case uint64:
				x.MultipleOf = float64(v22)
			case uint32:
				x.MultipleOf = float64(v22)
			case int64:
				x.MultipleOf = float64(v22)
			case int32:
				x.MultipleOf = float64(v22)
			case int:
				x.MultipleOf = float64(v22)
			default:
				message := fmt.Sprintf("has unexpected value for multipleOf: %+v (%T)", v22, v22)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny vendor_extension = 23;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewHeader creates an object of type Header if possible, returning an error if not.
func NewHeader(in interface{}, context *compiler.Context) (*Header, error) {
	errors := make([]error, 0)
	x := &Header{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"type"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"collectionFormat", "default", "description", "enum", "exclusiveMaximum", "exclusiveMinimum", "format", "items", "maxItems", "maxLength", "maximum", "minItems", "minLength", "minimum", "multipleOf", "pattern", "type", "uniqueItems"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string type = 1;
		v1 := compiler.MapValueForKey(m, "type")
		if v1 != nil {
			x.Type, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [string number integer boolean array]
			if ok && !compiler.StringArrayContainsValue([]string{"string", "number", "integer", "boolean", "array"}, x.Type) {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string format = 2;
		v2 := compiler.MapValueForKey(m, "format")
		if v2 != nil {
			x.Format, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for format: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// PrimitivesItems items = 3;
		v3 := compiler.MapValueForKey(m, "items")
		if v3 != nil {
			var err error
			x.Items, err = NewPrimitivesItems(v3, compiler.NewContext("items", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string collection_format = 4;
		v4 := compiler.MapValueForKey(m, "collectionFormat")
		if v4 != nil {
			x.CollectionFormat, ok = v4.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for collectionFormat: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [csv ssv tsv pipes]
			if ok && !compiler.StringArrayContainsValue([]string{"csv", "ssv", "tsv", "pipes"}, x.CollectionFormat) {
				message := fmt.Sprintf("has unexpected value for collectionFormat: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Any default = 5;
		v5 := compiler.MapValueForKey(m, "default")
		if v5 != nil {
			var err error
			x.Default, err = NewAny(v5, compiler.NewContext("default", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// float maximum = 6;
		v6 := compiler.MapValueForKey(m, "maximum")
		if v6 != nil {
			switch v6 := v6.(type) {
			case float64:
				x.Maximum = v6
			case float32:
				x.Maximum = float64(v6)
			case uint64:
				x.Maximum = float64(v6)
			case uint32:
				x.Maximum = float64(v6)
			case int64:
				x.Maximum = float64(v6)
			case int32:
				x.Maximum = float64(v6)
			case int:
				x.Maximum = float64(v6)
			default:
				message := fmt.Sprintf("has unexpected value for maximum: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool exclusive_maximum = 7;
		v7 := compiler.MapValueForKey(m, "exclusiveMaximum")
		if v7 != nil {
			x.ExclusiveMaximum, ok = v7.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for exclusiveMaximum: %+v (%T)", v7, v7)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// float minimum = 8;
		v8 := compiler.MapValueForKey(m, "minimum")
		if v8 != nil {
			switch v8 := v8.(type) {
			case float64:
				x.Minimum = v8
			case float32:
				x.Minimum = float64(v8)
			case uint64:
				x.Minimum = float64(v8)
			case uint32:
				x.Minimum = float64(v8)
			case int64:
				x.Minimum = float64(v8)
			case int32:
				x.Minimum = float64(v8)
			case int:
				x.Minimum = float64(v8)
			default:
				message := fmt.Sprintf("has unexpected value for minimum: %+v (%T)", v8, v8)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool exclusive_minimum = 9;
		v9 := compiler.MapValueForKey(m, "exclusiveMinimum")
		if v9 != nil {
			x.ExclusiveMinimum, ok = v9.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for exclusiveMinimum: %+v (%T)", v9, v9)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 max_length = 10;
		v10 := compiler.MapValueForKey(m, "maxLength")
		if v10 != nil {
			t, ok := v10.(int)
			if ok {
				x.MaxLength = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for maxLength: %+v (%T)", v10, v10)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 min_length = 11;
		v11 := compiler.MapValueForKey(m, "minLength")
		if v11 != nil {
			t, ok := v11.(int)
			if ok {
				x.MinLength = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for minLength: %+v (%T)", v11, v11)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string pattern = 12;
		v12 := compiler.MapValueForKey(m, "pattern")
		if v12 != nil {
			x.Pattern, ok = v12.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for pattern: %+v (%T)", v12, v12)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 max_items = 13;
		v13 := compiler.MapValueForKey(m, "maxItems")
		if v13 != nil {
			t, ok := v13.(int)
			if ok {
				x.MaxItems = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for maxItems: %+v (%T)", v13, v13)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 min_items = 14;
		v14 := compiler.MapValueForKey(m, "minItems")
		if v14 != nil {
			t, ok := v14.(int)
			if ok {
				x.MinItems = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for minItems: %+v (%T)", v14, v14)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool unique_items = 15;
		v15 := compiler.MapValueForKey(m, "uniqueItems")
		if v15 != nil {
			x.UniqueItems, ok = v15.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for uniqueItems: %+v (%T)", v15, v15)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated Any enum = 16;
		v16 := compiler.MapValueForKey(m, "enum")
		if v16 != nil {
			// repeated Any
			x.Enum = make([]*Any, 0)
			a, ok := v16.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewAny(item, compiler.NewContext("enum", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Enum = append(x.Enum, y)
				}
			}
		}
		// float multiple_of = 17;
		v17 := compiler.MapValueForKey(m, "multipleOf")
		if v17 != nil {
			switch v17 := v17.(type) {
			case float64:
				x.MultipleOf = v17
			case float32:
				x.MultipleOf = float64(v17)
			case uint64:
				x.MultipleOf = float64(v17)
			case uint32:
				x.MultipleOf = float64(v17)
			case int64:
				x.MultipleOf = float64(v17)
			case int32:
				x.MultipleOf = float64(v17)
			case int:
				x.MultipleOf = float64(v17)
			default:
				message := fmt.Sprintf("has unexpected value for multipleOf: %+v (%T)", v17, v17)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 18;
		v18 := compiler.MapValueForKey(m, "description")
		if v18 != nil {
			x.Description, ok = v18.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v18, v18)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny vendor_extension = 19;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewHeaderParameterSubSchema creates an object of type HeaderParameterSubSchema if possible, returning an error if not.
func NewHeaderParameterSubSchema(in interface{}, context *compiler.Context) (*HeaderParameterSubSchema, error) {
	errors := make([]error, 0)
	x := &HeaderParameterSubSchema{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"collectionFormat", "default", "description", "enum", "exclusiveMaximum", "exclusiveMinimum", "format", "in", "items", "maxItems", "maxLength", "maximum", "minItems", "minLength", "minimum", "multipleOf", "name", "pattern", "required", "type", "uniqueItems"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// bool required = 1;
		v1 := compiler.MapValueForKey(m, "required")
		if v1 != nil {
			x.Required, ok = v1.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for required: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string in = 2;
		v2 := compiler.MapValueForKey(m, "in")
		if v2 != nil {
			x.In, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for in: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [header]
			if ok && !compiler.StringArrayContainsValue([]string{"header"}, x.In) {
				message := fmt.Sprintf("has unexpected value for in: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 3;
		v3 := compiler.MapValueForKey(m, "description")
		if v3 != nil {
			x.Description, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string name = 4;
		v4 := compiler.MapValueForKey(m, "name")
		if v4 != nil {
			x.Name, ok = v4.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string type = 5;
		v5 := compiler.MapValueForKey(m, "type")
		if v5 != nil {
			x.Type, ok = v5.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [string number boolean integer array]
			if ok && !compiler.StringArrayContainsValue([]string{"string", "number", "boolean", "integer", "array"}, x.Type) {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string format = 6;
		v6 := compiler.MapValueForKey(m, "format")
		if v6 != nil {
			x.Format, ok = v6.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for format: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// PrimitivesItems items = 7;
		v7 := compiler.MapValueForKey(m, "items")
		if v7 != nil {
			var err error
			x.Items, err = NewPrimitivesItems(v7, compiler.NewContext("items", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string collection_format = 8;
		v8 := compiler.MapValueForKey(m, "collectionFormat")
		if v8 != nil {
			x.CollectionFormat, ok = v8.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for collectionFormat: %+v (%T)", v8, v8)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [csv ssv tsv pipes]
			if ok && !compiler.StringArrayContainsValue([]string{"csv", "ssv", "tsv", "pipes"}, x.CollectionFormat) {
				message := fmt.Sprintf("has unexpected value for collectionFormat: %+v (%T)", v8, v8)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Any default = 9;
		v9 := compiler.MapValueForKey(m, "default")
		if v9 != nil {
			var err error
			x.Default, err = NewAny(v9, compiler.NewContext("default", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// float maximum = 10;
		v10 := compiler.MapValueForKey(m, "maximum")
		if v10 != nil {
			switch v10 := v10.(type) {
			case float64:
				x.Maximum = v10
			case float32:
				x.Maximum = float64(v10)
			case uint64:
				x.Maximum = float64(v10)
			case uint32:
				x.Maximum = float64(v10)
			case int64:
				x.Maximum = float64(v10)
			case int32:
				x.Maximum = float64(v10)
			case int:
				x.Maximum = float64(v10)
			default:
				message := fmt.Sprintf("has unexpected value for maximum: %+v (%T)", v10, v10)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool exclusive_maximum = 11;
		v11 := compiler.MapValueForKey(m, "exclusiveMaximum")
		if v11 != nil {
			x.ExclusiveMaximum, ok = v11.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for exclusiveMaximum: %+v (%T)", v11, v11)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// float minimum = 12;
		v12 := compiler.MapValueForKey(m, "minimum")
		if v12 != nil {
			switch v12 := v12.(type) {
			case float64:
				x.Minimum = v12
			case float32:
				x.Minimum = float64(v12)
			case uint64:
				x.Minimum = float64(v12)
			case uint32:
				x.Minimum = float64(v12)
			case int64:
				x.Minimum = float64(v12)
			case int32:
				x.Minimum = float64(v12)
			case int:
				x.Minimum = float64(v12)
			default:
				message := fmt.Sprintf("has unexpected value for minimum: %+v (%T)", v12, v12)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool exclusive_minimum = 13;
		v13 := compiler.MapValueForKey(m, "exclusiveMinimum")
		if v13 != nil {
			x.ExclusiveMinimum, ok = v13.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for exclusiveMinimum: %+v (%T)", v13, v13)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 max_length = 14;
		v14 := compiler.MapValueForKey(m, "maxLength")
		if v14 != nil {
			t, ok := v14.(int)
			if ok {
				x.MaxLength = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for maxLength: %+v (%T)", v14, v14)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 min_length = 15;
		v15 := compiler.MapValueForKey(m, "minLength")
		if v15 != nil {
			t, ok := v15.(int)
			if ok {
				x.MinLength = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for minLength: %+v (%T)", v15, v15)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string pattern = 16;
		v16 := compiler.MapValueForKey(m, "pattern")
		if v16 != nil {
			x.Pattern, ok = v16.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for pattern: %+v (%T)", v16, v16)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 max_items = 17;
		v17 := compiler.MapValueForKey(m, "maxItems")
		if v17 != nil {
			t, ok := v17.(int)
			if ok {
				x.MaxItems = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for maxItems: %+v (%T)", v17, v17)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 min_items = 18;
		v18 := compiler.MapValueForKey(m, "minItems")
		if v18 != nil {
			t, ok := v18.(int)
			if ok {
				x.MinItems = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for minItems: %+v (%T)", v18, v18)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool unique_items = 19;
		v19 := compiler.MapValueForKey(m, "uniqueItems")
		if v19 != nil {
			x.UniqueItems, ok = v19.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for uniqueItems: %+v (%T)", v19, v19)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated Any enum = 20;
		v20 := compiler.MapValueForKey(m, "enum")
		if v20 != nil {
			// repeated Any
			x.Enum = make([]*Any, 0)
			a, ok := v20.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewAny(item, compiler.NewContext("enum", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Enum = append(x.Enum, y)
				}
			}
		}
		// float multiple_of = 21;
		v21 := compiler.MapValueForKey(m, "multipleOf")
		if v21 != nil {
			switch v21 := v21.(type) {
			case float64:
				x.MultipleOf = v21
			case float32:
				x.MultipleOf = float64(v21)
			case uint64:
				x.MultipleOf = float64(v21)
			case uint32:
				x.MultipleOf = float64(v21)
			case int64:
				x.MultipleOf = float64(v21)
			case int32:
				x.MultipleOf = float64(v21)
			case int:
				x.MultipleOf = float64(v21)
			default:
				message := fmt.Sprintf("has unexpected value for multipleOf: %+v (%T)", v21, v21)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny vendor_extension = 22;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewHeaders creates an object of type Headers if possible, returning an error if not.
func NewHeaders(in interface{}, context *compiler.Context) (*Headers, error) {
	errors := make([]error, 0)
	x := &Headers{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedHeader additional_properties = 1;
		// MAP: Header
		x.AdditionalProperties = make([]*NamedHeader, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedHeader{}
				pair.Name = k
				var err error
				pair.Value, err = NewHeader(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewInfo creates an object of type Info if possible, returning an error if not.
func NewInfo(in interface{}, context *compiler.Context) (*Info, error) {
	errors := make([]error, 0)
	x := &Info{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"title", "version"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"contact", "description", "license", "termsOfService", "title", "version"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string title = 1;
		v1 := compiler.MapValueForKey(m, "title")
		if v1 != nil {
			x.Title, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for title: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string version = 2;
		v2 := compiler.MapValueForKey(m, "version")
		if v2 != nil {
			x.Version, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for version: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 3;
		v3 := compiler.MapValueForKey(m, "description")
		if v3 != nil {
			x.Description, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string terms_of_service = 4;
		v4 := compiler.MapValueForKey(m, "termsOfService")
		if v4 != nil {
			x.TermsOfService, ok = v4.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for termsOfService: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Contact contact = 5;
		v5 := compiler.MapValueForKey(m, "contact")
		if v5 != nil {
			var err error
			x.Contact, err = NewContact(v5, compiler.NewContext("contact", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// License license = 6;
		v6 := compiler.MapValueForKey(m, "license")
		if v6 != nil {
			var err error
			x.License, err = NewLicense(v6, compiler.NewContext("license", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated NamedAny vendor_extension = 7;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewItemsItem creates an object of type ItemsItem if possible, returning an error if not.
func NewItemsItem(in interface{}, context *compiler.Context) (*ItemsItem, error) {
	errors := make([]error, 0)
	x := &ItemsItem{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value for item array: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		x.Schema = make([]*Schema, 0)
		y, err := NewSchema(m, compiler.NewContext("<array>", context))
		if err != nil {
			return nil, err
		}
		x.Schema = append(x.Schema, y)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewJsonReference creates an object of type JsonReference if possible, returning an error if not.
func NewJsonReference(in interface{}, context *compiler.Context) (*JsonReference, error) {
	errors := make([]error, 0)
	x := &JsonReference{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"$ref"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"$ref", "description"}
		allowedPatterns := []string{}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string _ref = 1;
		v1 := compiler.MapValueForKey(m, "$ref")
		if v1 != nil {
			x.XRef, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for $ref: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 2;
		v2 := compiler.MapValueForKey(m, "description")
		if v2 != nil {
			x.Description, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewLicense creates an object of type License if possible, returning an error if not.
func NewLicense(in interface{}, context *compiler.Context) (*License, error) {
	errors := make([]error, 0)
	x := &License{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"name"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"name", "url"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string url = 2;
		v2 := compiler.MapValueForKey(m, "url")
		if v2 != nil {
			x.Url, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for url: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny vendor_extension = 3;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedAny creates an object of type NamedAny if possible, returning an error if not.
func NewNamedAny(in interface{}, context *compiler.Context) (*NamedAny, error) {
	errors := make([]error, 0)
	x := &NamedAny{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		allowedPatterns := []string{}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Any value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewAny(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedHeader creates an object of type NamedHeader if possible, returning an error if not.
func NewNamedHeader(in interface{}, context *compiler.Context) (*NamedHeader, error) {
	errors := make([]error, 0)
	x := &NamedHeader{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		allowedPatterns := []string{}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Header value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewHeader(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedParameter creates an object of type NamedParameter if possible, returning an error if not.
func NewNamedParameter(in interface{}, context *compiler.Context) (*NamedParameter, error) {
	errors := make([]error, 0)
	x := &NamedParameter{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		allowedPatterns := []string{}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Parameter value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewParameter(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedPathItem creates an object of type NamedPathItem if possible, returning an error if not.
func NewNamedPathItem(in interface{}, context *compiler.Context) (*NamedPathItem, error) {
	errors := make([]error, 0)
	x := &NamedPathItem{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		allowedPatterns := []string{}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// PathItem value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewPathItem(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedResponse creates an object of type NamedResponse if possible, returning an error if not.
func NewNamedResponse(in interface{}, context *compiler.Context) (*NamedResponse, error) {
	errors := make([]error, 0)
	x := &NamedResponse{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		allowedPatterns := []string{}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Response value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewResponse(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedResponseValue creates an object of type NamedResponseValue if possible, returning an error if not.
func NewNamedResponseValue(in interface{}, context *compiler.Context) (*NamedResponseValue, error) {
	errors := make([]error, 0)
	x := &NamedResponseValue{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		allowedPatterns := []string{}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// ResponseValue value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewResponseValue(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedSchema creates an object of type NamedSchema if possible, returning an error if not.
func NewNamedSchema(in interface{}, context *compiler.Context) (*NamedSchema, error) {
	errors := make([]error, 0)
	x := &NamedSchema{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		allowedPatterns := []string{}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Schema value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewSchema(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedSecurityDefinitionsItem creates an object of type NamedSecurityDefinitionsItem if possible, returning an error if not.
func NewNamedSecurityDefinitionsItem(in interface{}, context *compiler.Context) (*NamedSecurityDefinitionsItem, error) {
	errors := make([]error, 0)
	x := &NamedSecurityDefinitionsItem{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		allowedPatterns := []string{}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// SecurityDefinitionsItem value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewSecurityDefinitionsItem(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedString creates an object of type NamedString if possible, returning an error if not.
func NewNamedString(in interface{}, context *compiler.Context) (*NamedString, error) {
	errors := make([]error, 0)
	x := &NamedString{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		allowedPatterns := []string{}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			x.Value, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for value: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedStringArray creates an object of type NamedStringArray if possible, returning an error if not.
func NewNamedStringArray(in interface{}, context *compiler.Context) (*NamedStringArray, error) {
	errors := make([]error, 0)
	x := &NamedStringArray{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		allowedPatterns := []string{}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// StringArray value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewStringArray(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNonBodyParameter creates an object of type NonBodyParameter if possible, returning an error if not.
func NewNonBodyParameter(in interface{}, context *compiler.Context) (*NonBodyParameter, error) {
	errors := make([]error, 0)
	x := &NonBodyParameter{}
	matched := false
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"in", "name", "type"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// HeaderParameterSubSchema header_parameter_sub_schema = 1;
		{
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewHeaderParameterSubSchema(m, compiler.NewContext("headerParameterSubSchema", context))
			if matchingError == nil {
				x.Oneof = &NonBodyParameter_HeaderParameterSubSchema{HeaderParameterSubSchema: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
		// FormDataParameterSubSchema form_data_parameter_sub_schema = 2;
		{
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewFormDataParameterSubSchema(m, compiler.NewContext("formDataParameterSubSchema", context))
			if matchingError == nil {
				x.Oneof = &NonBodyParameter_FormDataParameterSubSchema{FormDataParameterSubSchema: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
		// QueryParameterSubSchema query_parameter_sub_schema = 3;
		{
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewQueryParameterSubSchema(m, compiler.NewContext("queryParameterSubSchema", context))
			if matchingError == nil {
				x.Oneof = &NonBodyParameter_QueryParameterSubSchema{QueryParameterSubSchema: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
		// PathParameterSubSchema path_parameter_sub_schema = 4;
		{
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewPathParameterSubSchema(m, compiler.NewContext("pathParameterSubSchema", context))
			if matchingError == nil {
				x.Oneof = &NonBodyParameter_PathParameterSubSchema{PathParameterSubSchema: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	if matched {
		// since the oneof matched one of its possibilities, discard any matching errors
		errors = make([]error, 0)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewOauth2AccessCodeSecurity creates an object of type Oauth2AccessCodeSecurity if possible, returning an error if not.
func NewOauth2AccessCodeSecurity(in interface{}, context *compiler.Context) (*Oauth2AccessCodeSecurity, error) {
	errors := make([]error, 0)
	x := &Oauth2AccessCodeSecurity{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"authorizationUrl", "flow", "tokenUrl", "type"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"authorizationUrl", "description", "flow", "scopes", "tokenUrl", "type"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string type = 1;
		v1 := compiler.MapValueForKey(m, "type")
		if v1 != nil {
			x.Type, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [oauth2]
			if ok && !compiler.StringArrayContainsValue([]string{"oauth2"}, x.Type) {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string flow = 2;
		v2 := compiler.MapValueForKey(m, "flow")
		if v2 != nil {
			x.Flow, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for flow: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [accessCode]
			if ok && !compiler.StringArrayContainsValue([]string{"accessCode"}, x.Flow) {
				message := fmt.Sprintf("has unexpected value for flow: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Oauth2Scopes scopes = 3;
		v3 := compiler.MapValueForKey(m, "scopes")
		if v3 != nil {
			var err error
			x.Scopes, err = NewOauth2Scopes(v3, compiler.NewContext("scopes", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string authorization_url = 4;
		v4 := compiler.MapValueForKey(m, "authorizationUrl")
		if v4 != nil {
			x.AuthorizationUrl, ok = v4.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for authorizationUrl: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string token_url = 5;
		v5 := compiler.MapValueForKey(m, "tokenUrl")
		if v5 != nil {
			x.TokenUrl, ok = v5.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for tokenUrl: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 6;
		v6 := compiler.MapValueForKey(m, "description")
		if v6 != nil {
			x.Description, ok = v6.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny vendor_extension = 7;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewOauth2ApplicationSecurity creates an object of type Oauth2ApplicationSecurity if possible, returning an error if not.
func NewOauth2ApplicationSecurity(in interface{}, context *compiler.Context) (*Oauth2ApplicationSecurity, error) {
	errors := make([]error, 0)
	x := &Oauth2ApplicationSecurity{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"flow", "tokenUrl", "type"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"description", "flow", "scopes", "tokenUrl", "type"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string type = 1;
		v1 := compiler.MapValueForKey(m, "type")
		if v1 != nil {
			x.Type, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [oauth2]
			if ok && !compiler.StringArrayContainsValue([]string{"oauth2"}, x.Type) {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string flow = 2;
		v2 := compiler.MapValueForKey(m, "flow")
		if v2 != nil {
			x.Flow, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for flow: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [application]
			if ok && !compiler.StringArrayContainsValue([]string{"application"}, x.Flow) {
				message := fmt.Sprintf("has unexpected value for flow: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Oauth2Scopes scopes = 3;
		v3 := compiler.MapValueForKey(m, "scopes")
		if v3 != nil {
			var err error
			x.Scopes, err = NewOauth2Scopes(v3, compiler.NewContext("scopes", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string token_url = 4;
		v4 := compiler.MapValueForKey(m, "tokenUrl")
		if v4 != nil {
			x.TokenUrl, ok = v4.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for tokenUrl: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 5;
		v5 := compiler.MapValueForKey(m, "description")
		if v5 != nil {
			x.Description, ok = v5.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny vendor_extension = 6;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewOauth2ImplicitSecurity creates an object of type Oauth2ImplicitSecurity if possible, returning an error if not.
func NewOauth2ImplicitSecurity(in interface{}, context *compiler.Context) (*Oauth2ImplicitSecurity, error) {
	errors := make([]error, 0)
	x := &Oauth2ImplicitSecurity{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"authorizationUrl", "flow", "type"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"authorizationUrl", "description", "flow", "scopes", "type"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string type = 1;
		v1 := compiler.MapValueForKey(m, "type")
		if v1 != nil {
			x.Type, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [oauth2]
			if ok && !compiler.StringArrayContainsValue([]string{"oauth2"}, x.Type) {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string flow = 2;
		v2 := compiler.MapValueForKey(m, "flow")
		if v2 != nil {
			x.Flow, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for flow: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [implicit]
			if ok && !compiler.StringArrayContainsValue([]string{"implicit"}, x.Flow) {
				message := fmt.Sprintf("has unexpected value for flow: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Oauth2Scopes scopes = 3;
		v3 := compiler.MapValueForKey(m, "scopes")
		if v3 != nil {
			var err error
			x.Scopes, err = NewOauth2Scopes(v3, compiler.NewContext("scopes", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string authorization_url = 4;
		v4 := compiler.MapValueForKey(m, "authorizationUrl")
		if v4 != nil {
			x.AuthorizationUrl, ok = v4.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for authorizationUrl: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 5;
		v5 := compiler.MapValueForKey(m, "description")
		if v5 != nil {
			x.Description, ok = v5.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny vendor_extension = 6;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewOauth2PasswordSecurity creates an object of type Oauth2PasswordSecurity if possible, returning an error if not.
func NewOauth2PasswordSecurity(in interface{}, context *compiler.Context) (*Oauth2PasswordSecurity, error) {
	errors := make([]error, 0)
	x := &Oauth2PasswordSecurity{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"flow", "tokenUrl", "type"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"description", "flow", "scopes", "tokenUrl", "type"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string type = 1;
		v1 := compiler.MapValueForKey(m, "type")
		if v1 != nil {
			x.Type, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [oauth2]
			if ok && !compiler.StringArrayContainsValue([]string{"oauth2"}, x.Type) {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string flow = 2;
		v2 := compiler.MapValueForKey(m, "flow")
		if v2 != nil {
			x.Flow, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for flow: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [password]
			if ok && !compiler.StringArrayContainsValue([]string{"password"}, x.Flow) {
				message := fmt.Sprintf("has unexpected value for flow: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Oauth2Scopes scopes = 3;
		v3 := compiler.MapValueForKey(m, "scopes")
		if v3 != nil {
			var err error
			x.Scopes, err = NewOauth2Scopes(v3, compiler.NewContext("scopes", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string token_url = 4;
		v4 := compiler.MapValueForKey(m, "tokenUrl")
		if v4 != nil {
			x.TokenUrl, ok = v4.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for tokenUrl: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 5;
		v5 := compiler.MapValueForKey(m, "description")
		if v5 != nil {
			x.Description, ok = v5.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny vendor_extension = 6;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewOauth2Scopes creates an object of type Oauth2Scopes if possible, returning an error if not.
func NewOauth2Scopes(in interface{}, context *compiler.Context) (*Oauth2Scopes, error) {
	errors := make([]error, 0)
	x := &Oauth2Scopes{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedString additional_properties = 1;
		// MAP: string
		x.AdditionalProperties = make([]*NamedString, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedString{}
				pair.Name = k
				pair.Value = v.(string)
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewOperation creates an object of type Operation if possible, returning an error if not.
func NewOperation(in interface{}, context *compiler.Context) (*Operation, error) {
	errors := make([]error, 0)
	x := &Operation{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"responses"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"consumes", "deprecated", "description", "externalDocs", "operationId", "parameters", "produces", "responses", "schemes", "security", "summary", "tags"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// repeated string tags = 1;
		v1 := compiler.MapValueForKey(m, "tags")
		if v1 != nil {
			v, ok := v1.([]interface{})
			if ok {
				x.Tags = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for tags: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string summary = 2;
		v2 := compiler.MapValueForKey(m, "summary")
		if v2 != nil {
			x.Summary, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for summary: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 3;
		v3 := compiler.MapValueForKey(m, "description")
		if v3 != nil {
			x.Description, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// ExternalDocs external_docs = 4;
		v4 := compiler.MapValueForKey(m, "externalDocs")
		if v4 != nil {
			var err error
			x.ExternalDocs, err = NewExternalDocs(v4, compiler.NewContext("externalDocs", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string operation_id = 5;
		v5 := compiler.MapValueForKey(m, "operationId")
		if v5 != nil {
			x.OperationId, ok = v5.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for operationId: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated string produces = 6;
		v6 := compiler.MapValueForKey(m, "produces")
		if v6 != nil {
			v, ok := v6.([]interface{})
			if ok {
				x.Produces = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for produces: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated string consumes = 7;
		v7 := compiler.MapValueForKey(m, "consumes")
		if v7 != nil {
			v, ok := v7.([]interface{})
			if ok {
				x.Consumes = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for consumes: %+v (%T)", v7, v7)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated ParametersItem parameters = 8;
		v8 := compiler.MapValueForKey(m, "parameters")
		if v8 != nil {
			// repeated ParametersItem
			x.Parameters = make([]*ParametersItem, 0)
			a, ok := v8.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewParametersItem(item, compiler.NewContext("parameters", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Parameters = append(x.Parameters, y)
				}
			}
		}
		// Responses responses = 9;
		v9 := compiler.MapValueForKey(m, "responses")
		if v9 != nil {
			var err error
			x.Responses, err = NewResponses(v9, compiler.NewContext("responses", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated string schemes = 10;
		v10 := compiler.MapValueForKey(m, "schemes")
		if v10 != nil {
			v, ok := v10.([]interface{})
			if ok {
				x.Schemes = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for schemes: %+v (%T)", v10, v10)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [http https ws wss]
			if ok && !compiler.StringArrayContainsValues([]string{"http", "https", "ws", "wss"}, x.Schemes) {
				message := fmt.Sprintf("has unexpected value for schemes: %+v", v10)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool deprecated = 11;
		v11 := compiler.MapValueForKey(m, "deprecated")
		if v11 != nil {
			x.Deprecated, ok = v11.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for deprecated: %+v (%T)", v11, v11)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated SecurityRequirement security = 12;
		v12 := compiler.MapValueForKey(m, "security")
		if v12 != nil {
			// repeated SecurityRequirement
			x.Security = make([]*SecurityRequirement, 0)
			a, ok := v12.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewSecurityRequirement(item, compiler.NewContext("security", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Security = append(x.Security, y)
				}
			}
		}
		// repeated NamedAny vendor_extension = 13;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewParameter creates an object of type Parameter if possible, returning an error if not.
func NewParameter(in interface{}, context *compiler.Context) (*Parameter, error) {
	errors := make([]error, 0)
	x := &Parameter{}
	matched := false
	// BodyParameter body_parameter = 1;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewBodyParameter(m, compiler.NewContext("bodyParameter", context))
			if matchingError == nil {
				x.Oneof = &Parameter_BodyParameter{BodyParameter: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// NonBodyParameter non_body_parameter = 2;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewNonBodyParameter(m, compiler.NewContext("nonBodyParameter", context))
			if matchingError == nil {
				x.Oneof = &Parameter_NonBodyParameter{NonBodyParameter: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	if matched {
		// since the oneof matched one of its possibilities, discard any matching errors
		errors = make([]error, 0)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewParameterDefinitions creates an object of type ParameterDefinitions if possible, returning an error if not.
func NewParameterDefinitions(in interface{}, context *compiler.Context) (*ParameterDefinitions, error) {
	errors := make([]error, 0)
	x := &ParameterDefinitions{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedParameter additional_properties = 1;
		// MAP: Parameter
		x.AdditionalProperties = make([]*NamedParameter, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedParameter{}
				pair.Name = k
				var err error
				pair.Value, err = NewParameter(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewParametersItem creates an object of type ParametersItem if possible, returning an error if not.
func NewParametersItem(in interface{}, context *compiler.Context) (*ParametersItem, error) {
	errors := make([]error, 0)
	x := &ParametersItem{}
	matched := false
	// Parameter parameter = 1;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewParameter(m, compiler.NewContext("parameter", context))
			if matchingError == nil {
				x.Oneof = &ParametersItem_Parameter{Parameter: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// JsonReference json_reference = 2;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewJsonReference(m, compiler.NewContext("jsonReference", context))
			if matchingError == nil {
				x.Oneof = &ParametersItem_JsonReference{JsonReference: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	if matched {
		// since the oneof matched one of its possibilities, discard any matching errors
		errors = make([]error, 0)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewPathItem creates an object of type PathItem if possible, returning an error if not.
func NewPathItem(in interface{}, context *compiler.Context) (*PathItem, error) {
	errors := make([]error, 0)
	x := &PathItem{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"$ref", "delete", "get", "head", "options", "parameters", "patch", "post", "put"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string _ref = 1;
		v1 := compiler.MapValueForKey(m, "$ref")
		if v1 != nil {
			x.XRef, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for $ref: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Operation get = 2;
		v2 := compiler.MapValueForKey(m, "get")
		if v2 != nil {
			var err error
			x.Get, err = NewOperation(v2, compiler.NewContext("get", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Operation put = 3;
		v3 := compiler.MapValueForKey(m, "put")
		if v3 != nil {
			var err error
			x.Put, err = NewOperation(v3, compiler.NewContext("put", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Operation post = 4;
		v4 := compiler.MapValueForKey(m, "post")
		if v4 != nil {
			var err error
			x.Post, err = NewOperation(v4, compiler.NewContext("post", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Operation delete = 5;
		v5 := compiler.MapValueForKey(m, "delete")
		if v5 != nil {
			var err error
			x.Delete, err = NewOperation(v5, compiler.NewContext("delete", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Operation options = 6;
		v6 := compiler.MapValueForKey(m, "options")
		if v6 != nil {
			var err error
			x.Options, err = NewOperation(v6, compiler.NewContext("options", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Operation head = 7;
		v7 := compiler.MapValueForKey(m, "head")
		if v7 != nil {
			var err error
			x.Head, err = NewOperation(v7, compiler.NewContext("head", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Operation patch = 8;
		v8 := compiler.MapValueForKey(m, "patch")
		if v8 != nil {
			var err error
			x.Patch, err = NewOperation(v8, compiler.NewContext("patch", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated ParametersItem parameters = 9;
		v9 := compiler.MapValueForKey(m, "parameters")
		if v9 != nil {
			// repeated ParametersItem
			x.Parameters = make([]*ParametersItem, 0)
			a, ok := v9.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewParametersItem(item, compiler.NewContext("parameters", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Parameters = append(x.Parameters, y)
				}
			}
		}
		// repeated NamedAny vendor_extension = 10;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewPathParameterSubSchema creates an object of type PathParameterSubSchema if possible, returning an error if not.
func NewPathParameterSubSchema(in interface{}, context *compiler.Context) (*PathParameterSubSchema, error) {
	errors := make([]error, 0)
	x := &PathParameterSubSchema{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"required"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"collectionFormat", "default", "description", "enum", "exclusiveMaximum", "exclusiveMinimum", "format", "in", "items", "maxItems", "maxLength", "maximum", "minItems", "minLength", "minimum", "multipleOf", "name", "pattern", "required", "type", "uniqueItems"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// bool required = 1;
		v1 := compiler.MapValueForKey(m, "required")
		if v1 != nil {
			x.Required, ok = v1.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for required: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string in = 2;
		v2 := compiler.MapValueForKey(m, "in")
		if v2 != nil {
			x.In, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for in: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [path]
			if ok && !compiler.StringArrayContainsValue([]string{"path"}, x.In) {
				message := fmt.Sprintf("has unexpected value for in: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 3;
		v3 := compiler.MapValueForKey(m, "description")
		if v3 != nil {
			x.Description, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string name = 4;
		v4 := compiler.MapValueForKey(m, "name")
		if v4 != nil {
			x.Name, ok = v4.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string type = 5;
		v5 := compiler.MapValueForKey(m, "type")
		if v5 != nil {
			x.Type, ok = v5.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [string number boolean integer array]
			if ok && !compiler.StringArrayContainsValue([]string{"string", "number", "boolean", "integer", "array"}, x.Type) {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string format = 6;
		v6 := compiler.MapValueForKey(m, "format")
		if v6 != nil {
			x.Format, ok = v6.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for format: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// PrimitivesItems items = 7;
		v7 := compiler.MapValueForKey(m, "items")
		if v7 != nil {
			var err error
			x.Items, err = NewPrimitivesItems(v7, compiler.NewContext("items", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string collection_format = 8;
		v8 := compiler.MapValueForKey(m, "collectionFormat")
		if v8 != nil {
			x.CollectionFormat, ok = v8.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for collectionFormat: %+v (%T)", v8, v8)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [csv ssv tsv pipes]
			if ok && !compiler.StringArrayContainsValue([]string{"csv", "ssv", "tsv", "pipes"}, x.CollectionFormat) {
				message := fmt.Sprintf("has unexpected value for collectionFormat: %+v (%T)", v8, v8)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Any default = 9;
		v9 := compiler.MapValueForKey(m, "default")
		if v9 != nil {
			var err error
			x.Default, err = NewAny(v9, compiler.NewContext("default", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// float maximum = 10;
		v10 := compiler.MapValueForKey(m, "maximum")
		if v10 != nil {
			switch v10 := v10.(type) {
			case float64:
				x.Maximum = v10
			case float32:
				x.Maximum = float64(v10)
			case uint64:
				x.Maximum = float64(v10)
			case uint32:
				x.Maximum = float64(v10)
			case int64:
				x.Maximum = float64(v10)
			case int32:
				x.Maximum = float64(v10)
			case int:
				x.Maximum = float64(v10)
			default:
				message := fmt.Sprintf("has unexpected value for maximum: %+v (%T)", v10, v10)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool exclusive_maximum = 11;
		v11 := compiler.MapValueForKey(m, "exclusiveMaximum")
		if v11 != nil {
			x.ExclusiveMaximum, ok = v11.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for exclusiveMaximum: %+v (%T)", v11, v11)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// float minimum = 12;
		v12 := compiler.MapValueForKey(m, "minimum")
		if v12 != nil {
			switch v12 := v12.(type) {
			case float64:
				x.Minimum = v12
			case float32:
				x.Minimum = float64(v12)
			case uint64:
				x.Minimum = float64(v12)
			case uint32:
				x.Minimum = float64(v12)
			case int64:
				x.Minimum = float64(v12)
			case int32:
				x.Minimum = float64(v12)
			case int:
				x.Minimum = float64(v12)
			default:
				message := fmt.Sprintf("has unexpected value for minimum: %+v (%T)", v12, v12)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool exclusive_minimum = 13;
		v13 := compiler.MapValueForKey(m, "exclusiveMinimum")
		if v13 != nil {
			x.ExclusiveMinimum, ok = v13.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for exclusiveMinimum: %+v (%T)", v13, v13)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 max_length = 14;
		v14 := compiler.MapValueForKey(m, "maxLength")
		if v14 != nil {
			t, ok := v14.(int)
			if ok {
				x.MaxLength = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for maxLength: %+v (%T)", v14, v14)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 min_length = 15;
		v15 := compiler.MapValueForKey(m, "minLength")
		if v15 != nil {
			t, ok := v15.(int)
			if ok {
				x.MinLength = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for minLength: %+v (%T)", v15, v15)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string pattern = 16;
		v16 := compiler.MapValueForKey(m, "pattern")
		if v16 != nil {
			x.Pattern, ok = v16.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for pattern: %+v (%T)", v16, v16)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 max_items = 17;
		v17 := compiler.MapValueForKey(m, "maxItems")
		if v17 != nil {
			t, ok := v17.(int)
			if ok {
				x.MaxItems = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for maxItems: %+v (%T)", v17, v17)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 min_items = 18;
		v18 := compiler.MapValueForKey(m, "minItems")
		if v18 != nil {
			t, ok := v18.(int)
			if ok {
				x.MinItems = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for minItems: %+v (%T)", v18, v18)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool unique_items = 19;
		v19 := compiler.MapValueForKey(m, "uniqueItems")
		if v19 != nil {
			x.UniqueItems, ok = v19.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for uniqueItems: %+v (%T)", v19, v19)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated Any enum = 20;
		v20 := compiler.MapValueForKey(m, "enum")
		if v20 != nil {
			// repeated Any
			x.Enum = make([]*Any, 0)
			a, ok := v20.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewAny(item, compiler.NewContext("enum", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Enum = append(x.Enum, y)
				}
			}
		}
		// float multiple_of = 21;
		v21 := compiler.MapValueForKey(m, "multipleOf")
		if v21 != nil {
			switch v21 := v21.(type) {
			case float64:
				x.MultipleOf = v21
			case float32:
				x.MultipleOf = float64(v21)
			case uint64:
				x.MultipleOf = float64(v21)
			case uint32:
				x.MultipleOf = float64(v21)
			case int64:
				x.MultipleOf = float64(v21)
			case int32:
				x.MultipleOf = float64(v21)
			case int:
				x.MultipleOf = float64(v21)
			default:
				message := fmt.Sprintf("has unexpected value for multipleOf: %+v (%T)", v21, v21)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny vendor_extension = 22;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewPaths creates an object of type Paths if possible, returning an error if not.
func NewPaths(in interface{}, context *compiler.Context) (*Paths, error) {
	errors := make([]error, 0)
	x := &Paths{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{}
		allowedPatterns := []string{"^x-", "^/"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// repeated NamedAny vendor_extension = 1;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
		// repeated NamedPathItem path = 2;
		// MAP: PathItem ^/
		x.Path = make([]*NamedPathItem, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^/", k) {
					pair := &NamedPathItem{}
					pair.Name = k
					var err error
					pair.Value, err = NewPathItem(v, compiler.NewContext(k, context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Path = append(x.Path, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewPrimitivesItems creates an object of type PrimitivesItems if possible, returning an error if not.
func NewPrimitivesItems(in interface{}, context *compiler.Context) (*PrimitivesItems, error) {
	errors := make([]error, 0)
	x := &PrimitivesItems{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"collectionFormat", "default", "enum", "exclusiveMaximum", "exclusiveMinimum", "format", "items", "maxItems", "maxLength", "maximum", "minItems", "minLength", "minimum", "multipleOf", "pattern", "type", "uniqueItems"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string type = 1;
		v1 := compiler.MapValueForKey(m, "type")
		if v1 != nil {
			x.Type, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [string number integer boolean array]
			if ok && !compiler.StringArrayContainsValue([]string{"string", "number", "integer", "boolean", "array"}, x.Type) {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string format = 2;
		v2 := compiler.MapValueForKey(m, "format")
		if v2 != nil {
			x.Format, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for format: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// PrimitivesItems items = 3;
		v3 := compiler.MapValueForKey(m, "items")
		if v3 != nil {
			var err error
			x.Items, err = NewPrimitivesItems(v3, compiler.NewContext("items", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string collection_format = 4;
		v4 := compiler.MapValueForKey(m, "collectionFormat")
		if v4 != nil {
			x.CollectionFormat, ok = v4.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for collectionFormat: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [csv ssv tsv pipes]
			if ok && !compiler.StringArrayContainsValue([]string{"csv", "ssv", "tsv", "pipes"}, x.CollectionFormat) {
				message := fmt.Sprintf("has unexpected value for collectionFormat: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Any default = 5;
		v5 := compiler.MapValueForKey(m, "default")
		if v5 != nil {
			var err error
			x.Default, err = NewAny(v5, compiler.NewContext("default", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// float maximum = 6;
		v6 := compiler.MapValueForKey(m, "maximum")
		if v6 != nil {
			switch v6 := v6.(type) {
			case float64:
				x.Maximum = v6
			case float32:
				x.Maximum = float64(v6)
			case uint64:
				x.Maximum = float64(v6)
			case uint32:
				x.Maximum = float64(v6)
			case int64:
				x.Maximum = float64(v6)
			case int32:
				x.Maximum = float64(v6)
			case int:
				x.Maximum = float64(v6)
			default:
				message := fmt.Sprintf("has unexpected value for maximum: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool exclusive_maximum = 7;
		v7 := compiler.MapValueForKey(m, "exclusiveMaximum")
		if v7 != nil {
			x.ExclusiveMaximum, ok = v7.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for exclusiveMaximum: %+v (%T)", v7, v7)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// float minimum = 8;
		v8 := compiler.MapValueForKey(m, "minimum")
		if v8 != nil {
			switch v8 := v8.(type) {
			case float64:
				x.Minimum = v8
			case float32:
				x.Minimum = float64(v8)
			case uint64:
				x.Minimum = float64(v8)
			case uint32:
				x.Minimum = float64(v8)
			case int64:
				x.Minimum = float64(v8)
			case int32:
				x.Minimum = float64(v8)
			case int:
				x.Minimum = float64(v8)
			default:
				message := fmt.Sprintf("has unexpected value for minimum: %+v (%T)", v8, v8)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool exclusive_minimum = 9;
		v9 := compiler.MapValueForKey(m, "exclusiveMinimum")
		if v9 != nil {
			x.ExclusiveMinimum, ok = v9.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for exclusiveMinimum: %+v (%T)", v9, v9)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 max_length = 10;
		v10 := compiler.MapValueForKey(m, "maxLength")
		if v10 != nil {
			t, ok := v10.(int)
			if ok {
				x.MaxLength = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for maxLength: %+v (%T)", v10, v10)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 min_length = 11;
		v11 := compiler.MapValueForKey(m, "minLength")
		if v11 != nil {
			t, ok := v11.(int)
			if ok {
				x.MinLength = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for minLength: %+v (%T)", v11, v11)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string pattern = 12;
		v12 := compiler.MapValueForKey(m, "pattern")
		if v12 != nil {
			x.Pattern, ok = v12.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for pattern: %+v (%T)", v12, v12)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 max_items = 13;
		v13 := compiler.MapValueForKey(m, "maxItems")
		if v13 != nil {
			t, ok := v13.(int)
			if ok {
				x.MaxItems = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for maxItems: %+v (%T)", v13, v13)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 min_items = 14;
		v14 := compiler.MapValueForKey(m, "minItems")
		if v14 != nil {
			t, ok := v14.(int)
			if ok {
				x.MinItems = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for minItems: %+v (%T)", v14, v14)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool unique_items = 15;
		v15 := compiler.MapValueForKey(m, "uniqueItems")
		if v15 != nil {
			x.UniqueItems, ok = v15.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for uniqueItems: %+v (%T)", v15, v15)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated Any enum = 16;
		v16 := compiler.MapValueForKey(m, "enum")
		if v16 != nil {
			// repeated Any
			x.Enum = make([]*Any, 0)
			a, ok := v16.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewAny(item, compiler.NewContext("enum", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Enum = append(x.Enum, y)
				}
			}
		}
		// float multiple_of = 17;
		v17 := compiler.MapValueForKey(m, "multipleOf")
		if v17 != nil {
			switch v17 := v17.(type) {
			case float64:
				x.MultipleOf = v17
			case float32:
				x.MultipleOf = float64(v17)
			case uint64:
				x.MultipleOf = float64(v17)
			case uint32:
				x.MultipleOf = float64(v17)
			case int64:
				x.MultipleOf = float64(v17)
			case int32:
				x.MultipleOf = float64(v17)
			case int:
				x.MultipleOf = float64(v17)
			default:
				message := fmt.Sprintf("has unexpected value for multipleOf: %+v (%T)", v17, v17)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny vendor_extension = 18;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewProperties creates an object of type Properties if possible, returning an error if not.
func NewProperties(in interface{}, context *compiler.Context) (*Properties, error) {
	errors := make([]error, 0)
	x := &Properties{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedSchema additional_properties = 1;
		// MAP: Schema
		x.AdditionalProperties = make([]*NamedSchema, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedSchema{}
				pair.Name = k
				var err error
				pair.Value, err = NewSchema(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewQueryParameterSubSchema creates an object of type QueryParameterSubSchema if possible, returning an error if not.
func NewQueryParameterSubSchema(in interface{}, context *compiler.Context) (*QueryParameterSubSchema, error) {
	errors := make([]error, 0)
	x := &QueryParameterSubSchema{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"allowEmptyValue", "collectionFormat", "default", "description", "enum", "exclusiveMaximum", "exclusiveMinimum", "format", "in", "items", "maxItems", "maxLength", "maximum", "minItems", "minLength", "minimum", "multipleOf", "name", "pattern", "required", "type", "uniqueItems"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// bool required = 1;
		v1 := compiler.MapValueForKey(m, "required")
		if v1 != nil {
			x.Required, ok = v1.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for required: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string in = 2;
		v2 := compiler.MapValueForKey(m, "in")
		if v2 != nil {
			x.In, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for in: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [query]
			if ok && !compiler.StringArrayContainsValue([]string{"query"}, x.In) {
				message := fmt.Sprintf("has unexpected value for in: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 3;
		v3 := compiler.MapValueForKey(m, "description")
		if v3 != nil {
			x.Description, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string name = 4;
		v4 := compiler.MapValueForKey(m, "name")
		if v4 != nil {
			x.Name, ok = v4.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool allow_empty_value = 5;
		v5 := compiler.MapValueForKey(m, "allowEmptyValue")
		if v5 != nil {
			x.AllowEmptyValue, ok = v5.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for allowEmptyValue: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string type = 6;
		v6 := compiler.MapValueForKey(m, "type")
		if v6 != nil {
			x.Type, ok = v6.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [string number boolean integer array]
			if ok && !compiler.StringArrayContainsValue([]string{"string", "number", "boolean", "integer", "array"}, x.Type) {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string format = 7;
		v7 := compiler.MapValueForKey(m, "format")
		if v7 != nil {
			x.Format, ok = v7.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for format: %+v (%T)", v7, v7)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// PrimitivesItems items = 8;
		v8 := compiler.MapValueForKey(m, "items")
		if v8 != nil {
			var err error
			x.Items, err = NewPrimitivesItems(v8, compiler.NewContext("items", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string collection_format = 9;
		v9 := compiler.MapValueForKey(m, "collectionFormat")
		if v9 != nil {
			x.CollectionFormat, ok = v9.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for collectionFormat: %+v (%T)", v9, v9)
				errors = append(errors, compiler.NewError(context, message))
			}
			// check for valid enum values
			// [csv ssv tsv pipes multi]
			if ok && !compiler.StringArrayContainsValue([]string{"csv", "ssv", "tsv", "pipes", "multi"}, x.CollectionFormat) {
				message := fmt.Sprintf("has unexpected value for collectionFormat: %+v (%T)", v9, v9)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Any default = 10;
		v10 := compiler.MapValueForKey(m, "default")
		if v10 != nil {
			var err error
			x.Default, err = NewAny(v10, compiler.NewContext("default", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// float maximum = 11;
		v11 := compiler.MapValueForKey(m, "maximum")
		if v11 != nil {
			switch v11 := v11.(type) {
			case float64:
				x.Maximum = v11
			case float32:
				x.Maximum = float64(v11)
			case uint64:
				x.Maximum = float64(v11)
			case uint32:
				x.Maximum = float64(v11)
			case int64:
				x.Maximum = float64(v11)
			case int32:
				x.Maximum = float64(v11)
			case int:
				x.Maximum = float64(v11)
			default:
				message := fmt.Sprintf("has unexpected value for maximum: %+v (%T)", v11, v11)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool exclusive_maximum = 12;
		v12 := compiler.MapValueForKey(m, "exclusiveMaximum")
		if v12 != nil {
			x.ExclusiveMaximum, ok = v12.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for exclusiveMaximum: %+v (%T)", v12, v12)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// float minimum = 13;
		v13 := compiler.MapValueForKey(m, "minimum")
		if v13 != nil {
			switch v13 := v13.(type) {
			case float64:
				x.Minimum = v13
			case float32:
				x.Minimum = float64(v13)
			case uint64:
				x.Minimum = float64(v13)
			case uint32:
				x.Minimum = float64(v13)
			case int64:
				x.Minimum = float64(v13)
			case int32:
				x.Minimum = float64(v13)
			case int:
				x.Minimum = float64(v13)
			default:
				message := fmt.Sprintf("has unexpected value for minimum: %+v (%T)", v13, v13)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool exclusive_minimum = 14;
		v14 := compiler.MapValueForKey(m, "exclusiveMinimum")
		if v14 != nil {
			x.ExclusiveMinimum, ok = v14.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for exclusiveMinimum: %+v (%T)", v14, v14)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 max_length = 15;
		v15 := compiler.MapValueForKey(m, "maxLength")
		if v15 != nil {
			t, ok := v15.(int)
			if ok {
				x.MaxLength = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for maxLength: %+v (%T)", v15, v15)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 min_length = 16;
		v16 := compiler.MapValueForKey(m, "minLength")
		if v16 != nil {
			t, ok := v16.(int)
			if ok {
				x.MinLength = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for minLength: %+v (%T)", v16, v16)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string pattern = 17;
		v17 := compiler.MapValueForKey(m, "pattern")
		if v17 != nil {
			x.Pattern, ok = v17.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for pattern: %+v (%T)", v17, v17)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 max_items = 18;
		v18 := compiler.MapValueForKey(m, "maxItems")
		if v18 != nil {
			t, ok := v18.(int)
			if ok {
				x.MaxItems = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for maxItems: %+v (%T)", v18, v18)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 min_items = 19;
		v19 := compiler.MapValueForKey(m, "minItems")
		if v19 != nil {
			t, ok := v19.(int)
			if ok {
				x.MinItems = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for minItems: %+v (%T)", v19, v19)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool unique_items = 20;
		v20 := compiler.MapValueForKey(m, "uniqueItems")
		if v20 != nil {
			x.UniqueItems, ok = v20.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for uniqueItems: %+v (%T)", v20, v20)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated Any enum = 21;
		v21 := compiler.MapValueForKey(m, "enum")
		if v21 != nil {
			// repeated Any
			x.Enum = make([]*Any, 0)
			a, ok := v21.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewAny(item, compiler.NewContext("enum", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Enum = append(x.Enum, y)
				}
			}
		}
		// float multiple_of = 22;
		v22 := compiler.MapValueForKey(m, "multipleOf")
		if v22 != nil {
			switch v22 := v22.(type) {
			case float64:
				x.MultipleOf = v22
			case float32:
				x.MultipleOf = float64(v22)
			case uint64:
				x.MultipleOf = float64(v22)
			case uint32:
				x.MultipleOf = float64(v22)
			case int64:
				x.MultipleOf = float64(v22)
			case int32:
				x.MultipleOf = float64(v22)
			case int:
				x.MultipleOf = float64(v22)
			default:
				message := fmt.Sprintf("has unexpected value for multipleOf: %+v (%T)", v22, v22)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny vendor_extension = 23;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewResponse creates an object of type Response if possible, returning an error if not.
func NewResponse(in interface{}, context *compiler.Context) (*Response, error) {
	errors := make([]error, 0)
	x := &Response{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"description"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"description", "examples", "headers", "schema"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string description = 1;
		v1 := compiler.MapValueForKey(m, "description")
		if v1 != nil {
			x.Description, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// SchemaItem schema = 2;
		v2 := compiler.MapValueForKey(m, "schema")
		if v2 != nil {
			var err error
			x.Schema, err = NewSchemaItem(v2, compiler.NewContext("schema", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Headers headers = 3;
		v3 := compiler.MapValueForKey(m, "headers")
		if v3 != nil {
			var err error
			x.Headers, err = NewHeaders(v3, compiler.NewContext("headers", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Examples examples = 4;
		v4 := compiler.MapValueForKey(m, "examples")
		if v4 != nil {
			var err error
			x.Examples, err = NewExamples(v4, compiler.NewContext("examples", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated NamedAny vendor_extension = 5;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewResponseDefinitions creates an object of type ResponseDefinitions if possible, returning an error if not.
func NewResponseDefinitions(in interface{}, context *compiler.Context) (*ResponseDefinitions, error) {
	errors := make([]error, 0)
	x := &ResponseDefinitions{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedResponse additional_properties = 1;
		// MAP: Response
		x.AdditionalProperties = make([]*NamedResponse, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedResponse{}
				pair.Name = k
				var err error
				pair.Value, err = NewResponse(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewResponseValue creates an object of type ResponseValue if possible, returning an error if not.
func NewResponseValue(in interface{}, context *compiler.Context) (*ResponseValue, error) {
	errors := make([]error, 0)
	x := &ResponseValue{}
	matched := false
	// Response response = 1;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewResponse(m, compiler.NewContext("response", context))
			if matchingError == nil {
				x.Oneof = &ResponseValue_Response{Response: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// JsonReference json_reference = 2;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewJsonReference(m, compiler.NewContext("jsonReference", context))
			if matchingError == nil {
				x.Oneof = &ResponseValue_JsonReference{JsonReference: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	if matched {
		// since the oneof matched one of its possibilities, discard any matching errors
		errors = make([]error, 0)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewResponses creates an object of type Responses if possible, returning an error if not.
func NewResponses(in interface{}, context *compiler.Context) (*Responses, error) {
	errors := make([]error, 0)
	x := &Responses{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{}
		allowedPatterns := []string{"^([0-9]{3})$|^(default)$", "^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// repeated NamedResponseValue response_code = 1;
		// MAP: ResponseValue ^([0-9]{3})$|^(default)$
		x.ResponseCode = make([]*NamedResponseValue, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^([0-9]{3})$|^(default)$", k) {
					pair := &NamedResponseValue{}
					pair.Name = k
					var err error
					pair.Value, err = NewResponseValue(v, compiler.NewContext(k, context))
					if err != nil {
						errors = append(errors, err)
					}
					x.ResponseCode = append(x.ResponseCode, pair)
				}
			}
		}
		// repeated NamedAny vendor_extension = 2;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewSchema creates an object of type Schema if possible, returning an error if not.
func NewSchema(in interface{}, context *compiler.Context) (*Schema, error) {
	errors := make([]error, 0)
	x := &Schema{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"$ref", "additionalProperties", "allOf", "default", "description", "discriminator", "enum", "example", "exclusiveMaximum", "exclusiveMinimum", "externalDocs", "format", "items", "maxItems", "maxLength", "maxProperties", "maximum", "minItems", "minLength", "minProperties", "minimum", "multipleOf", "pattern", "properties", "readOnly", "required", "title", "type", "uniqueItems", "xml"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string _ref = 1;
		v1 := compiler.MapValueForKey(m, "$ref")
		if v1 != nil {
			x.XRef, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for $ref: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string format = 2;
		v2 := compiler.MapValueForKey(m, "format")
		if v2 != nil {
			x.Format, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for format: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string title = 3;
		v3 := compiler.MapValueForKey(m, "title")
		if v3 != nil {
			x.Title, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for title: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 4;
		v4 := compiler.MapValueForKey(m, "description")
		if v4 != nil {
			x.Description, ok = v4.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Any default = 5;
		v5 := compiler.MapValueForKey(m, "default")
		if v5 != nil {
			var err error
			x.Default, err = NewAny(v5, compiler.NewContext("default", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// float multiple_of = 6;
		v6 := compiler.MapValueForKey(m, "multipleOf")
		if v6 != nil {
			switch v6 := v6.(type) {
			case float64:
				x.MultipleOf = v6
			case float32:
				x.MultipleOf = float64(v6)
			case uint64:
				x.MultipleOf = float64(v6)
			case uint32:
				x.MultipleOf = float64(v6)
			case int64:
				x.MultipleOf = float64(v6)
			case int32:
				x.MultipleOf = float64(v6)
			case int:
				x.MultipleOf = float64(v6)
			default:
				message := fmt.Sprintf("has unexpected value for multipleOf: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// float maximum = 7;
		v7 := compiler.MapValueForKey(m, "maximum")
		if v7 != nil {
			switch v7 := v7.(type) {
			case float64:
				x.Maximum = v7
			case float32:
				x.Maximum = float64(v7)
			case uint64:
				x.Maximum = float64(v7)
			case uint32:
				x.Maximum = float64(v7)
			case int64:
				x.Maximum = float64(v7)
			case int32:
				x.Maximum = float64(v7)
			case int:
				x.Maximum = float64(v7)
			default:
				message := fmt.Sprintf("has unexpected value for maximum: %+v (%T)", v7, v7)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool exclusive_maximum = 8;
		v8 := compiler.MapValueForKey(m, "exclusiveMaximum")
		if v8 != nil {
			x.ExclusiveMaximum, ok = v8.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for exclusiveMaximum: %+v (%T)", v8, v8)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// float minimum = 9;
		v9 := compiler.MapValueForKey(m, "minimum")
		if v9 != nil {
			switch v9 := v9.(type) {
			case float64:
				x.Minimum = v9
			case float32:
				x.Minimum = float64(v9)
			case uint64:
				x.Minimum = float64(v9)
			case uint32:
				x.Minimum = float64(v9)
			case int64:
				x.Minimum = float64(v9)
			case int32:
				x.Minimum = float64(v9)
			case int:
				x.Minimum = float64(v9)
			default:
				message := fmt.Sprintf("has unexpected value for minimum: %+v (%T)", v9, v9)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool exclusive_minimum = 10;
		v10 := compiler.MapValueForKey(m, "exclusiveMinimum")
		if v10 != nil {
			x.ExclusiveMinimum, ok = v10.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for exclusiveMinimum: %+v (%T)", v10, v10)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 max_length = 11;
		v11 := compiler.MapValueForKey(m, "maxLength")
		if v11 != nil {
			t, ok := v11.(int)
			if ok {
				x.MaxLength = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for maxLength: %+v (%T)", v11, v11)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 min_length = 12;
		v12 := compiler.MapValueForKey(m, "minLength")
		if v12 != nil {
			t, ok := v12.(int)
			if ok {
				x.MinLength = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for minLength: %+v (%T)", v12, v12)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string pattern = 13;
		v13 := compiler.MapValueForKey(m, "pattern")
		if v13 != nil {
			x.Pattern, ok = v13.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for pattern: %+v (%T)", v13, v13)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 max_items = 14;
		v14 := compiler.MapValueForKey(m, "maxItems")
		if v14 != nil {
			t, ok := v14.(int)
			if ok {
				x.MaxItems = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for maxItems: %+v (%T)", v14, v14)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 min_items = 15;
		v15 := compiler.MapValueForKey(m, "minItems")
		if v15 != nil {
			t, ok := v15.(int)
			if ok {
				x.MinItems = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for minItems: %+v (%T)", v15, v15)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool unique_items = 16;
		v16 := compiler.MapValueForKey(m, "uniqueItems")
		if v16 != nil {
			x.UniqueItems, ok = v16.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for uniqueItems: %+v (%T)", v16, v16)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 max_properties = 17;
		v17 := compiler.MapValueForKey(m, "maxProperties")
		if v17 != nil {
			t, ok := v17.(int)
			if ok {
				x.MaxProperties = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for maxProperties: %+v (%T)", v17, v17)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// int64 min_properties = 18;
		v18 := compiler.MapValueForKey(m, "minProperties")
		if v18 != nil {
			t, ok := v18.(int)
			if ok {
				x.MinProperties = int64(t)
			} else {
				message := fmt.Sprintf("has unexpected value for minProperties: %+v (%T)", v18, v18)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated string required = 19;
		v19 := compiler.MapValueForKey(m, "required")
		if v19 != nil {
			v, ok := v19.([]interface{})
			if ok {
				x.Required = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for required: %+v (%T)", v19, v19)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated Any enum = 20;
		v20 := compiler.MapValueForKey(m, "enum")
		if v20 != nil {
			// repeated Any
			x.Enum = make([]*Any, 0)
			a, ok := v20.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewAny(item, compiler.NewContext("enum", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.Enum = append(x.Enum, y)
				}
			}
		}
		// AdditionalPropertiesItem additional_properties = 21;
		v21 := compiler.MapValueForKey(m, "additionalProperties")
		if v21 != nil {
			var err error
			x.AdditionalProperties, err = NewAdditionalPropertiesItem(v21, compiler.NewContext("additionalProperties", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// TypeItem type = 22;
		v22 := compiler.MapValueForKey(m, "type")
		if v22 != nil {
			var err error
			x.Type, err = NewTypeItem(v22, compiler.NewContext("type", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// ItemsItem items = 23;
		v23 := compiler.MapValueForKey(m, "items")
		if v23 != nil {
			var err error
			x.Items, err = NewItemsItem(v23, compiler.NewContext("items", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated Schema all_of = 24;
		v24 := compiler.MapValueForKey(m, "allOf")
		if v24 != nil {
			// repeated Schema
			x.AllOf = make([]*Schema, 0)
			a, ok := v24.([]interface{})
			if ok {
				for _, item := range a {
					y, err := NewSchema(item, compiler.NewContext("allOf", context))
					if err != nil {
						errors = append(errors, err)
					}
					x.AllOf = append(x.AllOf, y)
				}
			}
		}
		// Properties properties = 25;
		v25 := compiler.MapValueForKey(m, "properties")
		if v25 != nil {
			var err error
			x.Properties, err = NewProperties(v25, compiler.NewContext("properties", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string discriminator = 26;
		v26 := compiler.MapValueForKey(m, "discriminator")
		if v26 != nil {
			x.Discriminator, ok = v26.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for discriminator: %+v (%T)", v26, v26)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool read_only = 27;
		v27 := compiler.MapValueForKey(m, "readOnly")
		if v27 != nil {
			x.ReadOnly, ok = v27.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for readOnly: %+v (%T)", v27, v27)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Xml xml = 28;
		v28 := compiler.MapValueForKey(m, "xml")
		if v28 != nil {
			var err error
			x.Xml, err = NewXml(v28, compiler.NewContext("xml", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// ExternalDocs external_docs = 29;
		v29 := compiler.MapValueForKey(m, "externalDocs")
		if v29 != nil {
			var err error
			x.ExternalDocs, err = NewExternalDocs(v29, compiler.NewContext("externalDocs", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Any example = 30;
		v30 := compiler.MapValueForKey(m, "example")
		if v30 != nil {
			var err error
			x.Example, err = NewAny(v30, compiler.NewContext("example", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated NamedAny vendor_extension = 31;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewSchemaItem creates an object of type SchemaItem if possible, returning an error if not.
func NewSchemaItem(in interface{}, context *compiler.Context) (*SchemaItem, error) {
	errors := make([]error, 0)
	x := &SchemaItem{}
	matched := false
	// Schema schema = 1;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewSchema(m, compiler.NewContext("schema", context))
			if matchingError == nil {
				x.Oneof = &SchemaItem_Schema{Schema: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// FileSchema file_schema = 2;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewFileSchema(m, compiler.NewContext("fileSchema", context))
			if matchingError == nil {
				x.Oneof = &SchemaItem_FileSchema{FileSchema: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	if matched {
		// since the oneof matched one of its possibilities, discard any matching errors
		errors = make([]error, 0)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewSecurityDefinitions creates an object of type SecurityDefinitions if possible, returning an error if not.
func NewSecurityDefinitions(in interface{}, context *compiler.Context) (*SecurityDefinitions, error) {
	errors := make([]error, 0)
	x := &SecurityDefinitions{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedSecurityDefinitionsItem additional_properties = 1;
		// MAP: SecurityDefinitionsItem
		x.AdditionalProperties = make([]*NamedSecurityDefinitionsItem, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedSecurityDefinitionsItem{}
				pair.Name = k
				var err error
				pair.Value, err = NewSecurityDefinitionsItem(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewSecurityDefinitionsItem creates an object of type SecurityDefinitionsItem if possible, returning an error if not.
func NewSecurityDefinitionsItem(in interface{}, context *compiler.Context) (*SecurityDefinitionsItem, error) {
	errors := make([]error, 0)
	x := &SecurityDefinitionsItem{}
	matched := false
	// BasicAuthenticationSecurity basic_authentication_security = 1;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewBasicAuthenticationSecurity(m, compiler.NewContext("basicAuthenticationSecurity", context))
			if matchingError == nil {
				x.Oneof = &SecurityDefinitionsItem_BasicAuthenticationSecurity{BasicAuthenticationSecurity: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// ApiKeySecurity api_key_security = 2;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewApiKeySecurity(m, compiler.NewContext("apiKeySecurity", context))
			if matchingError == nil {
				x.Oneof = &SecurityDefinitionsItem_ApiKeySecurity{ApiKeySecurity: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// Oauth2ImplicitSecurity oauth2_implicit_security = 3;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewOauth2ImplicitSecurity(m, compiler.NewContext("oauth2ImplicitSecurity", context))
			if matchingError == nil {
				x.Oneof = &SecurityDefinitionsItem_Oauth2ImplicitSecurity{Oauth2ImplicitSecurity: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// Oauth2PasswordSecurity oauth2_password_security = 4;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewOauth2PasswordSecurity(m, compiler.NewContext("oauth2PasswordSecurity", context))
			if matchingError == nil {
				x.Oneof = &SecurityDefinitionsItem_Oauth2PasswordSecurity{Oauth2PasswordSecurity: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// Oauth2ApplicationSecurity oauth2_application_security = 5;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewOauth2ApplicationSecurity(m, compiler.NewContext("oauth2ApplicationSecurity", context))
			if matchingError == nil {
				x.Oneof = &SecurityDefinitionsItem_Oauth2ApplicationSecurity{Oauth2ApplicationSecurity: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	// Oauth2AccessCodeSecurity oauth2_access_code_security = 6;
	{
		m, ok := compiler.UnpackMap(in)
		if ok {
			// errors might be ok here, they mean we just don't have the right subtype
			t, matchingError := NewOauth2AccessCodeSecurity(m, compiler.NewContext("oauth2AccessCodeSecurity", context))
			if matchingError == nil {
				x.Oneof = &SecurityDefinitionsItem_Oauth2AccessCodeSecurity{Oauth2AccessCodeSecurity: t}
				matched = true
			} else {
				errors = append(errors, matchingError)
			}
		}
	}
	if matched {
		// since the oneof matched one of its possibilities, discard any matching errors
		errors = make([]error, 0)
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewSecurityRequirement creates an object of type SecurityRequirement if possible, returning an error if not.
func NewSecurityRequirement(in interface{}, context *compiler.Context) (*SecurityRequirement, error) {
	errors := make([]error, 0)
	x := &SecurityRequirement{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedStringArray additional_properties = 1;
		// MAP: StringArray
		x.AdditionalProperties = make([]*NamedStringArray, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedStringArray{}
				pair.Name = k
				var err error
				pair.Value, err = NewStringArray(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewStringArray creates an object of type StringArray if possible, returning an error if not.
func NewStringArray(in interface{}, context *compiler.Context) (*StringArray, error) {
	errors := make([]error, 0)
	x := &StringArray{}
	a, ok := in.([]interface{})
	if !ok {
		message := fmt.Sprintf("has unexpected value for StringArray: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		x.Value = make([]string, 0)
		for _, s := range a {
			x.Value = append(x.Value, s.(string))
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewTag creates an object of type Tag if possible, returning an error if not.
func NewTag(in interface{}, context *compiler.Context) (*Tag, error) {
	errors := make([]error, 0)
	x := &Tag{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"name"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"description", "externalDocs", "name"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 2;
		v2 := compiler.MapValueForKey(m, "description")
		if v2 != nil {
			x.Description, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// ExternalDocs external_docs = 3;
		v3 := compiler.MapValueForKey(m, "externalDocs")
		if v3 != nil {
			var err error
			x.ExternalDocs, err = NewExternalDocs(v3, compiler.NewContext("externalDocs", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated NamedAny vendor_extension = 4;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewTypeItem creates an object of type TypeItem if possible, returning an error if not.
func NewTypeItem(in interface{}, context *compiler.Context) (*TypeItem, error) {
	errors := make([]error, 0)
	x := &TypeItem{}
	switch in := in.(type) {
	case string:
		x.Value = make([]string, 0)
		x.Value = append(x.Value, in)
	case []interface{}:
		x.Value = make([]string, 0)
		for _, v := range in {
			value, ok := v.(string)
			if ok {
				x.Value = append(x.Value, value)
			} else {
				message := fmt.Sprintf("has unexpected value for string array element: %+v (%T)", value, value)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	default:
		message := fmt.Sprintf("has unexpected value for string array: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewVendorExtension creates an object of type VendorExtension if possible, returning an error if not.
func NewVendorExtension(in interface{}, context *compiler.Context) (*VendorExtension, error) {
	errors := make([]error, 0)
	x := &VendorExtension{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedAny additional_properties = 1;
		// MAP: Any
		x.AdditionalProperties = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedAny{}
				pair.Name = k
				result := &Any{}
				handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
				if handled {
					if err != nil {
						errors = append(errors, err)
					} else {
						bytes, _ := yaml.Marshal(v)
						result.Yaml = string(bytes)
						result.Value = resultFromExt
						pair.Value = result
					}
				} else {
					pair.Value, err = NewAny(v, compiler.NewContext(k, context))
					if err != nil {
						errors = append(errors, err)
					}
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewXml creates an object of type Xml if possible, returning an error if not.
func NewXml(in interface{}, context *compiler.Context) (*Xml, error) {
	errors := make([]error, 0)
	x := &Xml{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"attribute", "name", "namespace", "prefix", "wrapped"}
		allowedPatterns := []string{"^x-"}
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string namespace = 2;
		v2 := compiler.MapValueForKey(m, "namespace")
		if v2 != nil {
			x.Namespace, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for namespace: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string prefix = 3;
		v3 := compiler.MapValueForKey(m, "prefix")
		if v3 != nil {
			x.Prefix, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for prefix: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool attribute = 4;
		v4 := compiler.MapValueForKey(m, "attribute")
		if v4 != nil {
			x.Attribute, ok = v4.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for attribute: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool wrapped = 5;
		v5 := compiler.MapValueForKey(m, "wrapped")
		if v5 != nil {
			x.Wrapped, ok = v5.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for wrapped: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated NamedAny vendor_extension = 6;
		// MAP: Any ^x-
		x.VendorExtension = make([]*NamedAny, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				if compiler.PatternMatches("^x-", k) {
					pair := &NamedAny{}
					pair.Name = k
					result := &Any{}
					handled, resultFromExt, err := compiler.HandleExtension(context, v, k)
					if handled {
						if err != nil {
							errors = append(errors, err)
						} else {
							bytes, _ := yaml.Marshal(v)
							result.Yaml = string(bytes)
							result.Value = resultFromExt
							pair.Value = result
						}
					} else {
						pair.Value, err = NewAny(v, compiler.NewContext(k, context))
						if err != nil {
							errors = append(errors, err)
						}
					}
					x.VendorExtension = append(x.VendorExtension, pair)
				}
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside AdditionalPropertiesItem objects.
func (m *AdditionalPropertiesItem) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	{
		p, ok := m.Oneof.(*AdditionalPropertiesItem_Schema)
		if ok {
			_, err := p.Schema.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Any objects.
func (m *Any) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside ApiKeySecurity objects.
func (m *ApiKeySecurity) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside BasicAuthenticationSecurity objects.
func (m *BasicAuthenticationSecurity) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside BodyParameter objects.
func (m *BodyParameter) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Schema != nil {
		_, err := m.Schema.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Contact objects.
func (m *Contact) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Default objects.
func (m *Default) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Definitions objects.
func (m *Definitions) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Document objects.
func (m *Document) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Info != nil {
		_, err := m.Info.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Paths != nil {
		_, err := m.Paths.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Definitions != nil {
		_, err := m.Definitions.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Parameters != nil {
		_, err := m.Parameters.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Responses != nil {
		_, err := m.Responses.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.Security {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	if m.SecurityDefinitions != nil {
		_, err := m.SecurityDefinitions.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.Tags {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	if m.ExternalDocs != nil {
		_, err := m.ExternalDocs.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Examples objects.
func (m *Examples) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside ExternalDocs objects.
func (m *ExternalDocs) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside FileSchema objects.
func (m *FileSchema) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Default != nil {
		_, err := m.Default.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.ExternalDocs != nil {
		_, err := m.ExternalDocs.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Example != nil {
		_, err := m.Example.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside FormDataParameterSubSchema objects.
func (m *FormDataParameterSubSchema) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Items != nil {
		_, err := m.Items.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Default != nil {
		_, err := m.Default.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.Enum {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Header objects.
func (m *Header) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Items != nil {
		_, err := m.Items.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Default != nil {
		_, err := m.Default.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.Enum {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside HeaderParameterSubSchema objects.
func (m *HeaderParameterSubSchema) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Items != nil {
		_, err := m.Items.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Default != nil {
		_, err := m.Default.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.Enum {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Headers objects.
func (m *Headers) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Info objects.
func (m *Info) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Contact != nil {
		_, err := m.Contact.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.License != nil {
		_, err := m.License.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside ItemsItem objects.
func (m *ItemsItem) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.Schema {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside JsonReference objects.
func (m *JsonReference) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.XRef != "" {
		info, err := compiler.ReadInfoForRef(root, m.XRef)
		if err != nil {
			return nil, err
		}
		if info != nil {
			replacement, err := NewJsonReference(info, nil)
			if err == nil {
				*m = *replacement
				return m.ResolveReferences(root)
			}
		}
		return info, nil
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside License objects.
func (m *License) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedAny objects.
func (m *NamedAny) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedHeader objects.
func (m *NamedHeader) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedParameter objects.
func (m *NamedParameter) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedPathItem objects.
func (m *NamedPathItem) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedResponse objects.
func (m *NamedResponse) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedResponseValue objects.
func (m *NamedResponseValue) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedSchema objects.
func (m *NamedSchema) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedSecurityDefinitionsItem objects.
func (m *NamedSecurityDefinitionsItem) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedString objects.
func (m *NamedString) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedStringArray objects.
func (m *NamedStringArray) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NonBodyParameter objects.
func (m *NonBodyParameter) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	{
		p, ok := m.Oneof.(*NonBodyParameter_HeaderParameterSubSchema)
		if ok {
			_, err := p.HeaderParameterSubSchema.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*NonBodyParameter_FormDataParameterSubSchema)
		if ok {
			_, err := p.FormDataParameterSubSchema.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*NonBodyParameter_QueryParameterSubSchema)
		if ok {
			_, err := p.QueryParameterSubSchema.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*NonBodyParameter_PathParameterSubSchema)
		if ok {
			_, err := p.PathParameterSubSchema.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Oauth2AccessCodeSecurity objects.
func (m *Oauth2AccessCodeSecurity) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Scopes != nil {
		_, err := m.Scopes.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Oauth2ApplicationSecurity objects.
func (m *Oauth2ApplicationSecurity) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Scopes != nil {
		_, err := m.Scopes.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Oauth2ImplicitSecurity objects.
func (m *Oauth2ImplicitSecurity) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Scopes != nil {
		_, err := m.Scopes.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Oauth2PasswordSecurity objects.
func (m *Oauth2PasswordSecurity) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Scopes != nil {
		_, err := m.Scopes.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Oauth2Scopes objects.
func (m *Oauth2Scopes) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Operation objects.
func (m *Operation) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.ExternalDocs != nil {
		_, err := m.ExternalDocs.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.Parameters {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	if m.Responses != nil {
		_, err := m.Responses.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.Security {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Parameter objects.
func (m *Parameter) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	{
		p, ok := m.Oneof.(*Parameter_BodyParameter)
		if ok {
			_, err := p.BodyParameter.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*Parameter_NonBodyParameter)
		if ok {
			_, err := p.NonBodyParameter.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside ParameterDefinitions objects.
func (m *ParameterDefinitions) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside ParametersItem objects.
func (m *ParametersItem) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	{
		p, ok := m.Oneof.(*ParametersItem_Parameter)
		if ok {
			_, err := p.Parameter.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*ParametersItem_JsonReference)
		if ok {
			info, err := p.JsonReference.ResolveReferences(root)
			if err != nil {
				return nil, err
			} else if info != nil {
				n, err := NewParametersItem(info, nil)
				if err != nil {
					return nil, err
				} else if n != nil {
					*m = *n
					return nil, nil
				}
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside PathItem objects.
func (m *PathItem) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.XRef != "" {
		info, err := compiler.ReadInfoForRef(root, m.XRef)
		if err != nil {
			return nil, err
		}
		if info != nil {
			replacement, err := NewPathItem(info, nil)
			if err == nil {
				*m = *replacement
				return m.ResolveReferences(root)
			}
		}
		return info, nil
	}
	if m.Get != nil {
		_, err := m.Get.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Put != nil {
		_, err := m.Put.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Post != nil {
		_, err := m.Post.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Delete != nil {
		_, err := m.Delete.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Options != nil {
		_, err := m.Options.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Head != nil {
		_, err := m.Head.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Patch != nil {
		_, err := m.Patch.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.Parameters {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside PathParameterSubSchema objects.
func (m *PathParameterSubSchema) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Items != nil {
		_, err := m.Items.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Default != nil {
		_, err := m.Default.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.Enum {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Paths objects.
func (m *Paths) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.Path {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside PrimitivesItems objects.
func (m *PrimitivesItems) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Items != nil {
		_, err := m.Items.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Default != nil {
		_, err := m.Default.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.Enum {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Properties objects.
func (m *Properties) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside QueryParameterSubSchema objects.
func (m *QueryParameterSubSchema) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Items != nil {
		_, err := m.Items.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Default != nil {
		_, err := m.Default.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.Enum {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Response objects.
func (m *Response) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Schema != nil {
		_, err := m.Schema.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Headers != nil {
		_, err := m.Headers.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Examples != nil {
		_, err := m.Examples.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside ResponseDefinitions objects.
func (m *ResponseDefinitions) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside ResponseValue objects.
func (m *ResponseValue) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	{
		p, ok := m.Oneof.(*ResponseValue_Response)
		if ok {
			_, err := p.Response.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*ResponseValue_JsonReference)
		if ok {
			info, err := p.JsonReference.ResolveReferences(root)
			if err != nil {
				return nil, err
			} else if info != nil {
				n, err := NewResponseValue(info, nil)
				if err != nil {
					return nil, err
				} else if n != nil {
					*m = *n
					return nil, nil
				}
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Responses objects.
func (m *Responses) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.ResponseCode {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Schema objects.
func (m *Schema) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.XRef != "" {
		info, err := compiler.ReadInfoForRef(root, m.XRef)
		if err != nil {
			return nil, err
		}
		if info != nil {
			replacement, err := NewSchema(info, nil)
			if err == nil {
				*m = *replacement
				return m.ResolveReferences(root)
			}
		}
		return info, nil
	}
	if m.Default != nil {
		_, err := m.Default.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.Enum {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	if m.AdditionalProperties != nil {
		_, err := m.AdditionalProperties.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Type != nil {
		_, err := m.Type.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Items != nil {
		_, err := m.Items.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.AllOf {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	if m.Properties != nil {
		_, err := m.Properties.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Xml != nil {
		_, err := m.Xml.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.ExternalDocs != nil {
		_, err := m.ExternalDocs.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Example != nil {
		_, err := m.Example.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside SchemaItem objects.
func (m *SchemaItem) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	{
		p, ok := m.Oneof.(*SchemaItem_Schema)
		if ok {
			_, err := p.Schema.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*SchemaItem_FileSchema)
		if ok {
			_, err := p.FileSchema.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside SecurityDefinitions objects.
func (m *SecurityDefinitions) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside SecurityDefinitionsItem objects.
func (m *SecurityDefinitionsItem) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	{
		p, ok := m.Oneof.(*SecurityDefinitionsItem_BasicAuthenticationSecurity)
		if ok {
			_, err := p.BasicAuthenticationSecurity.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*SecurityDefinitionsItem_ApiKeySecurity)
		if ok {
			_, err := p.ApiKeySecurity.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*SecurityDefinitionsItem_Oauth2ImplicitSecurity)
		if ok {
			_, err := p.Oauth2ImplicitSecurity.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*SecurityDefinitionsItem_Oauth2PasswordSecurity)
		if ok {
			_, err := p.Oauth2PasswordSecurity.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*SecurityDefinitionsItem_Oauth2ApplicationSecurity)
		if ok {
			_, err := p.Oauth2ApplicationSecurity.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	{
		p, ok := m.Oneof.(*SecurityDefinitionsItem_Oauth2AccessCodeSecurity)
		if ok {
			_, err := p.Oauth2AccessCodeSecurity.ResolveReferences(root)
			if err != nil {
				return nil, err
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside SecurityRequirement objects.
func (m *SecurityRequirement) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside StringArray objects.
func (m *StringArray) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Tag objects.
func (m *Tag) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.ExternalDocs != nil {
		_, err := m.ExternalDocs.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside TypeItem objects.
func (m *TypeItem) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside VendorExtension objects.
func (m *VendorExtension) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Xml objects.
func (m *Xml) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.VendorExtension {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ToRawInfo returns a description of AdditionalPropertiesItem suitable for JSON or YAML export.
func (m *AdditionalPropertiesItem) ToRawInfo() interface{} {
	// ONE OF WRAPPER
	// AdditionalPropertiesItem
	// {Name:schema Type:Schema StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v0 := m.GetSchema()
	if v0 != nil {
		return v0.ToRawInfo()
	}
	// {Name:boolean Type:bool StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if v1, ok := m.GetOneof().(*AdditionalPropertiesItem_Boolean); ok {
		return v1.Boolean
	}
	return nil
}

// ToRawInfo returns a description of Any suitable for JSON or YAML export.
func (m *Any) ToRawInfo() interface{} {
	var err error
	var info1 []yaml.MapSlice
	err = yaml.Unmarshal([]byte(m.Yaml), &info1)
	if err == nil {
		return info1
	}
	var info2 yaml.MapSlice
	err = yaml.Unmarshal([]byte(m.Yaml), &info2)
	if err == nil {
		return info2
	}
	var info3 interface{}
	err = yaml.Unmarshal([]byte(m.Yaml), &info3)
	if err == nil {
		return info3
	}
	return nil
}

// ToRawInfo returns a description of ApiKeySecurity suitable for JSON or YAML export.
func (m *ApiKeySecurity) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Type != "" {
		info = append(info, yaml.MapItem{"type", m.Type})
	}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	if m.In != "" {
		info = append(info, yaml.MapItem{"in", m.In})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of BasicAuthenticationSecurity suitable for JSON or YAML export.
func (m *BasicAuthenticationSecurity) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Type != "" {
		info = append(info, yaml.MapItem{"type", m.Type})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of BodyParameter suitable for JSON or YAML export.
func (m *BodyParameter) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	if m.In != "" {
		info = append(info, yaml.MapItem{"in", m.In})
	}
	if m.Required != false {
		info = append(info, yaml.MapItem{"required", m.Required})
	}
	if m.Schema != nil {
		info = append(info, yaml.MapItem{"schema", m.Schema.ToRawInfo()})
	}
	// &{Name:schema Type:Schema StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Contact suitable for JSON or YAML export.
func (m *Contact) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	if m.Url != "" {
		info = append(info, yaml.MapItem{"url", m.Url})
	}
	if m.Email != "" {
		info = append(info, yaml.MapItem{"email", m.Email})
	}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Default suitable for JSON or YAML export.
func (m *Default) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern: Implicit:false Description:}
	return info
}

// ToRawInfo returns a description of Definitions suitable for JSON or YAML export.
func (m *Definitions) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedSchema StringEnumValues:[] MapType:Schema Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Document suitable for JSON or YAML export.
func (m *Document) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Swagger != "" {
		info = append(info, yaml.MapItem{"swagger", m.Swagger})
	}
	if m.Info != nil {
		info = append(info, yaml.MapItem{"info", m.Info.ToRawInfo()})
	}
	// &{Name:info Type:Info StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Host != "" {
		info = append(info, yaml.MapItem{"host", m.Host})
	}
	if m.BasePath != "" {
		info = append(info, yaml.MapItem{"basePath", m.BasePath})
	}
	if len(m.Schemes) != 0 {
		info = append(info, yaml.MapItem{"schemes", m.Schemes})
	}
	if len(m.Consumes) != 0 {
		info = append(info, yaml.MapItem{"consumes", m.Consumes})
	}
	if len(m.Produces) != 0 {
		info = append(info, yaml.MapItem{"produces", m.Produces})
	}
	if m.Paths != nil {
		info = append(info, yaml.MapItem{"paths", m.Paths.ToRawInfo()})
	}
	// &{Name:paths Type:Paths StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Definitions != nil {
		info = append(info, yaml.MapItem{"definitions", m.Definitions.ToRawInfo()})
	}
	// &{Name:definitions Type:Definitions StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Parameters != nil {
		info = append(info, yaml.MapItem{"parameters", m.Parameters.ToRawInfo()})
	}
	// &{Name:parameters Type:ParameterDefinitions StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Responses != nil {
		info = append(info, yaml.MapItem{"responses", m.Responses.ToRawInfo()})
	}
	// &{Name:responses Type:ResponseDefinitions StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if len(m.Security) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Security {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"security", items})
	}
	// &{Name:security Type:SecurityRequirement StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if m.SecurityDefinitions != nil {
		info = append(info, yaml.MapItem{"securityDefinitions", m.SecurityDefinitions.ToRawInfo()})
	}
	// &{Name:securityDefinitions Type:SecurityDefinitions StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if len(m.Tags) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Tags {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"tags", items})
	}
	// &{Name:tags Type:Tag StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if m.ExternalDocs != nil {
		info = append(info, yaml.MapItem{"externalDocs", m.ExternalDocs.ToRawInfo()})
	}
	// &{Name:externalDocs Type:ExternalDocs StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Examples suitable for JSON or YAML export.
func (m *Examples) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of ExternalDocs suitable for JSON or YAML export.
func (m *ExternalDocs) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Url != "" {
		info = append(info, yaml.MapItem{"url", m.Url})
	}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of FileSchema suitable for JSON or YAML export.
func (m *FileSchema) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Format != "" {
		info = append(info, yaml.MapItem{"format", m.Format})
	}
	if m.Title != "" {
		info = append(info, yaml.MapItem{"title", m.Title})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Default != nil {
		info = append(info, yaml.MapItem{"default", m.Default.ToRawInfo()})
	}
	// &{Name:default Type:Any StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if len(m.Required) != 0 {
		info = append(info, yaml.MapItem{"required", m.Required})
	}
	if m.Type != "" {
		info = append(info, yaml.MapItem{"type", m.Type})
	}
	if m.ReadOnly != false {
		info = append(info, yaml.MapItem{"readOnly", m.ReadOnly})
	}
	if m.ExternalDocs != nil {
		info = append(info, yaml.MapItem{"externalDocs", m.ExternalDocs.ToRawInfo()})
	}
	// &{Name:externalDocs Type:ExternalDocs StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Example != nil {
		info = append(info, yaml.MapItem{"example", m.Example.ToRawInfo()})
	}
	// &{Name:example Type:Any StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of FormDataParameterSubSchema suitable for JSON or YAML export.
func (m *FormDataParameterSubSchema) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Required != false {
		info = append(info, yaml.MapItem{"required", m.Required})
	}
	if m.In != "" {
		info = append(info, yaml.MapItem{"in", m.In})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	if m.AllowEmptyValue != false {
		info = append(info, yaml.MapItem{"allowEmptyValue", m.AllowEmptyValue})
	}
	if m.Type != "" {
		info = append(info, yaml.MapItem{"type", m.Type})
	}
	if m.Format != "" {
		info = append(info, yaml.MapItem{"format", m.Format})
	}
	if m.Items != nil {
		info = append(info, yaml.MapItem{"items", m.Items.ToRawInfo()})
	}
	// &{Name:items Type:PrimitivesItems StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.CollectionFormat != "" {
		info = append(info, yaml.MapItem{"collectionFormat", m.CollectionFormat})
	}
	if m.Default != nil {
		info = append(info, yaml.MapItem{"default", m.Default.ToRawInfo()})
	}
	// &{Name:default Type:Any StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Maximum != 0.0 {
		info = append(info, yaml.MapItem{"maximum", m.Maximum})
	}
	if m.ExclusiveMaximum != false {
		info = append(info, yaml.MapItem{"exclusiveMaximum", m.ExclusiveMaximum})
	}
	if m.Minimum != 0.0 {
		info = append(info, yaml.MapItem{"minimum", m.Minimum})
	}
	if m.ExclusiveMinimum != false {
		info = append(info, yaml.MapItem{"exclusiveMinimum", m.ExclusiveMinimum})
	}
	if m.MaxLength != 0 {
		info = append(info, yaml.MapItem{"maxLength", m.MaxLength})
	}
	if m.MinLength != 0 {
		info = append(info, yaml.MapItem{"minLength", m.MinLength})
	}
	if m.Pattern != "" {
		info = append(info, yaml.MapItem{"pattern", m.Pattern})
	}
	if m.MaxItems != 0 {
		info = append(info, yaml.MapItem{"maxItems", m.MaxItems})
	}
	if m.MinItems != 0 {
		info = append(info, yaml.MapItem{"minItems", m.MinItems})
	}
	if m.UniqueItems != false {
		info = append(info, yaml.MapItem{"uniqueItems", m.UniqueItems})
	}
	if len(m.Enum) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Enum {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"enum", items})
	}
	// &{Name:enum Type:Any StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if m.MultipleOf != 0.0 {
		info = append(info, yaml.MapItem{"multipleOf", m.MultipleOf})
	}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Header suitable for JSON or YAML export.
func (m *Header) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Type != "" {
		info = append(info, yaml.MapItem{"type", m.Type})
	}
	if m.Format != "" {
		info = append(info, yaml.MapItem{"format", m.Format})
	}
	if m.Items != nil {
		info = append(info, yaml.MapItem{"items", m.Items.ToRawInfo()})
	}
	// &{Name:items Type:PrimitivesItems StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.CollectionFormat != "" {
		info = append(info, yaml.MapItem{"collectionFormat", m.CollectionFormat})
	}
	if m.Default != nil {
		info = append(info, yaml.MapItem{"default", m.Default.ToRawInfo()})
	}
	// &{Name:default Type:Any StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Maximum != 0.0 {
		info = append(info, yaml.MapItem{"maximum", m.Maximum})
	}
	if m.ExclusiveMaximum != false {
		info = append(info, yaml.MapItem{"exclusiveMaximum", m.ExclusiveMaximum})
	}
	if m.Minimum != 0.0 {
		info = append(info, yaml.MapItem{"minimum", m.Minimum})
	}
	if m.ExclusiveMinimum != false {
		info = append(info, yaml.MapItem{"exclusiveMinimum", m.ExclusiveMinimum})
	}
	if m.MaxLength != 0 {
		info = append(info, yaml.MapItem{"maxLength", m.MaxLength})
	}
	if m.MinLength != 0 {
		info = append(info, yaml.MapItem{"minLength", m.MinLength})
	}
	if m.Pattern != "" {
		info = append(info, yaml.MapItem{"pattern", m.Pattern})
	}
	if m.MaxItems != 0 {
		info = append(info, yaml.MapItem{"maxItems", m.MaxItems})
	}
	if m.MinItems != 0 {
		info = append(info, yaml.MapItem{"minItems", m.MinItems})
	}
	if m.UniqueItems != false {
		info = append(info, yaml.MapItem{"uniqueItems", m.UniqueItems})
	}
	if len(m.Enum) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Enum {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"enum", items})
	}
	// &{Name:enum Type:Any StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if m.MultipleOf != 0.0 {
		info = append(info, yaml.MapItem{"multipleOf", m.MultipleOf})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of HeaderParameterSubSchema suitable for JSON or YAML export.
func (m *HeaderParameterSubSchema) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Required != false {
		info = append(info, yaml.MapItem{"required", m.Required})
	}
	if m.In != "" {
		info = append(info, yaml.MapItem{"in", m.In})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	if m.Type != "" {
		info = append(info, yaml.MapItem{"type", m.Type})
	}
	if m.Format != "" {
		info = append(info, yaml.MapItem{"format", m.Format})
	}
	if m.Items != nil {
		info = append(info, yaml.MapItem{"items", m.Items.ToRawInfo()})
	}
	// &{Name:items Type:PrimitivesItems StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.CollectionFormat != "" {
		info = append(info, yaml.MapItem{"collectionFormat", m.CollectionFormat})
	}
	if m.Default != nil {
		info = append(info, yaml.MapItem{"default", m.Default.ToRawInfo()})
	}
	// &{Name:default Type:Any StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Maximum != 0.0 {
		info = append(info, yaml.MapItem{"maximum", m.Maximum})
	}
	if m.ExclusiveMaximum != false {
		info = append(info, yaml.MapItem{"exclusiveMaximum", m.ExclusiveMaximum})
	}
	if m.Minimum != 0.0 {
		info = append(info, yaml.MapItem{"minimum", m.Minimum})
	}
	if m.ExclusiveMinimum != false {
		info = append(info, yaml.MapItem{"exclusiveMinimum", m.ExclusiveMinimum})
	}
	if m.MaxLength != 0 {
		info = append(info, yaml.MapItem{"maxLength", m.MaxLength})
	}
	if m.MinLength != 0 {
		info = append(info, yaml.MapItem{"minLength", m.MinLength})
	}
	if m.Pattern != "" {
		info = append(info, yaml.MapItem{"pattern", m.Pattern})
	}
	if m.MaxItems != 0 {
		info = append(info, yaml.MapItem{"maxItems", m.MaxItems})
	}
	if m.MinItems != 0 {
		info = append(info, yaml.MapItem{"minItems", m.MinItems})
	}
	if m.UniqueItems != false {
		info = append(info, yaml.MapItem{"uniqueItems", m.UniqueItems})
	}
	if len(m.Enum) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Enum {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"enum", items})
	}
	// &{Name:enum Type:Any StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if m.MultipleOf != 0.0 {
		info = append(info, yaml.MapItem{"multipleOf", m.MultipleOf})
	}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Headers suitable for JSON or YAML export.
func (m *Headers) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedHeader StringEnumValues:[] MapType:Header Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Info suitable for JSON or YAML export.
func (m *Info) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Title != "" {
		info = append(info, yaml.MapItem{"title", m.Title})
	}
	if m.Version != "" {
		info = append(info, yaml.MapItem{"version", m.Version})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.TermsOfService != "" {
		info = append(info, yaml.MapItem{"termsOfService", m.TermsOfService})
	}
	if m.Contact != nil {
		info = append(info, yaml.MapItem{"contact", m.Contact.ToRawInfo()})
	}
	// &{Name:contact Type:Contact StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.License != nil {
		info = append(info, yaml.MapItem{"license", m.License.ToRawInfo()})
	}
	// &{Name:license Type:License StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of ItemsItem suitable for JSON or YAML export.
func (m *ItemsItem) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if len(m.Schema) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Schema {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"schema", items})
	}
	// &{Name:schema Type:Schema StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	return info
}

// ToRawInfo returns a description of JsonReference suitable for JSON or YAML export.
func (m *JsonReference) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.XRef != "" {
		info = append(info, yaml.MapItem{"$ref", m.XRef})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	return info
}

// ToRawInfo returns a description of License suitable for JSON or YAML export.
func (m *License) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	if m.Url != "" {
		info = append(info, yaml.MapItem{"url", m.Url})
	}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of NamedAny suitable for JSON or YAML export.
func (m *NamedAny) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:Any StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedHeader suitable for JSON or YAML export.
func (m *NamedHeader) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:Header StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedParameter suitable for JSON or YAML export.
func (m *NamedParameter) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:Parameter StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedPathItem suitable for JSON or YAML export.
func (m *NamedPathItem) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:PathItem StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedResponse suitable for JSON or YAML export.
func (m *NamedResponse) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:Response StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedResponseValue suitable for JSON or YAML export.
func (m *NamedResponseValue) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:ResponseValue StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedSchema suitable for JSON or YAML export.
func (m *NamedSchema) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:Schema StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedSecurityDefinitionsItem suitable for JSON or YAML export.
func (m *NamedSecurityDefinitionsItem) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:SecurityDefinitionsItem StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedString suitable for JSON or YAML export.
func (m *NamedString) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	if m.Value != "" {
		info = append(info, yaml.MapItem{"value", m.Value})
	}
	return info
}

// ToRawInfo returns a description of NamedStringArray suitable for JSON or YAML export.
func (m *NamedStringArray) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:StringArray StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NonBodyParameter suitable for JSON or YAML export.
func (m *NonBodyParameter) ToRawInfo() interface{} {
	// ONE OF WRAPPER
	// NonBodyParameter
	// {Name:headerParameterSubSchema Type:HeaderParameterSubSchema StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v0 := m.GetHeaderParameterSubSchema()
	if v0 != nil {
		return v0.ToRawInfo()
	}
	// {Name:formDataParameterSubSchema Type:FormDataParameterSubSchema StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v1 := m.GetFormDataParameterSubSchema()
	if v1 != nil {
		return v1.ToRawInfo()
	}
	// {Name:queryParameterSubSchema Type:QueryParameterSubSchema StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v2 := m.GetQueryParameterSubSchema()
	if v2 != nil {
		return v2.ToRawInfo()
	}
	// {Name:pathParameterSubSchema Type:PathParameterSubSchema StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v3 := m.GetPathParameterSubSchema()
	if v3 != nil {
		return v3.ToRawInfo()
	}
	return nil
}

// ToRawInfo returns a description of Oauth2AccessCodeSecurity suitable for JSON or YAML export.
func (m *Oauth2AccessCodeSecurity) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Type != "" {
		info = append(info, yaml.MapItem{"type", m.Type})
	}
	if m.Flow != "" {
		info = append(info, yaml.MapItem{"flow", m.Flow})
	}
	if m.Scopes != nil {
		info = append(info, yaml.MapItem{"scopes", m.Scopes.ToRawInfo()})
	}
	// &{Name:scopes Type:Oauth2Scopes StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.AuthorizationUrl != "" {
		info = append(info, yaml.MapItem{"authorizationUrl", m.AuthorizationUrl})
	}
	if m.TokenUrl != "" {
		info = append(info, yaml.MapItem{"tokenUrl", m.TokenUrl})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Oauth2ApplicationSecurity suitable for JSON or YAML export.
func (m *Oauth2ApplicationSecurity) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Type != "" {
		info = append(info, yaml.MapItem{"type", m.Type})
	}
	if m.Flow != "" {
		info = append(info, yaml.MapItem{"flow", m.Flow})
	}
	if m.Scopes != nil {
		info = append(info, yaml.MapItem{"scopes", m.Scopes.ToRawInfo()})
	}
	// &{Name:scopes Type:Oauth2Scopes StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.TokenUrl != "" {
		info = append(info, yaml.MapItem{"tokenUrl", m.TokenUrl})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Oauth2ImplicitSecurity suitable for JSON or YAML export.
func (m *Oauth2ImplicitSecurity) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Type != "" {
		info = append(info, yaml.MapItem{"type", m.Type})
	}
	if m.Flow != "" {
		info = append(info, yaml.MapItem{"flow", m.Flow})
	}
	if m.Scopes != nil {
		info = append(info, yaml.MapItem{"scopes", m.Scopes.ToRawInfo()})
	}
	// &{Name:scopes Type:Oauth2Scopes StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.AuthorizationUrl != "" {
		info = append(info, yaml.MapItem{"authorizationUrl", m.AuthorizationUrl})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Oauth2PasswordSecurity suitable for JSON or YAML export.
func (m *Oauth2PasswordSecurity) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Type != "" {
		info = append(info, yaml.MapItem{"type", m.Type})
	}
	if m.Flow != "" {
		info = append(info, yaml.MapItem{"flow", m.Flow})
	}
	if m.Scopes != nil {
		info = append(info, yaml.MapItem{"scopes", m.Scopes.ToRawInfo()})
	}
	// &{Name:scopes Type:Oauth2Scopes StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.TokenUrl != "" {
		info = append(info, yaml.MapItem{"tokenUrl", m.TokenUrl})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Oauth2Scopes suitable for JSON or YAML export.
func (m *Oauth2Scopes) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	// &{Name:additionalProperties Type:NamedString StringEnumValues:[] MapType:string Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Operation suitable for JSON or YAML export.
func (m *Operation) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if len(m.Tags) != 0 {
		info = append(info, yaml.MapItem{"tags", m.Tags})
	}
	if m.Summary != "" {
		info = append(info, yaml.MapItem{"summary", m.Summary})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.ExternalDocs != nil {
		info = append(info, yaml.MapItem{"externalDocs", m.ExternalDocs.ToRawInfo()})
	}
	// &{Name:externalDocs Type:ExternalDocs StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.OperationId != "" {
		info = append(info, yaml.MapItem{"operationId", m.OperationId})
	}
	if len(m.Produces) != 0 {
		info = append(info, yaml.MapItem{"produces", m.Produces})
	}
	if len(m.Consumes) != 0 {
		info = append(info, yaml.MapItem{"consumes", m.Consumes})
	}
	if len(m.Parameters) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Parameters {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"parameters", items})
	}
	// &{Name:parameters Type:ParametersItem StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:The parameters needed to send a valid API call.}
	if m.Responses != nil {
		info = append(info, yaml.MapItem{"responses", m.Responses.ToRawInfo()})
	}
	// &{Name:responses Type:Responses StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if len(m.Schemes) != 0 {
		info = append(info, yaml.MapItem{"schemes", m.Schemes})
	}
	if m.Deprecated != false {
		info = append(info, yaml.MapItem{"deprecated", m.Deprecated})
	}
	if len(m.Security) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Security {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"security", items})
	}
	// &{Name:security Type:SecurityRequirement StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Parameter suitable for JSON or YAML export.
func (m *Parameter) ToRawInfo() interface{} {
	// ONE OF WRAPPER
	// Parameter
	// {Name:bodyParameter Type:BodyParameter StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v0 := m.GetBodyParameter()
	if v0 != nil {
		return v0.ToRawInfo()
	}
	// {Name:nonBodyParameter Type:NonBodyParameter StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v1 := m.GetNonBodyParameter()
	if v1 != nil {
		return v1.ToRawInfo()
	}
	return nil
}

// ToRawInfo returns a description of ParameterDefinitions suitable for JSON or YAML export.
func (m *ParameterDefinitions) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedParameter StringEnumValues:[] MapType:Parameter Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of ParametersItem suitable for JSON or YAML export.
func (m *ParametersItem) ToRawInfo() interface{} {
	// ONE OF WRAPPER
	// ParametersItem
	// {Name:parameter Type:Parameter StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v0 := m.GetParameter()
	if v0 != nil {
		return v0.ToRawInfo()
	}
	// {Name:jsonReference Type:JsonReference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v1 := m.GetJsonReference()
	if v1 != nil {
		return v1.ToRawInfo()
	}
	return nil
}

// ToRawInfo returns a description of PathItem suitable for JSON or YAML export.
func (m *PathItem) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.XRef != "" {
		info = append(info, yaml.MapItem{"$ref", m.XRef})
	}
	if m.Get != nil {
		info = append(info, yaml.MapItem{"get", m.Get.ToRawInfo()})
	}
	// &{Name:get Type:Operation StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Put != nil {
		info = append(info, yaml.MapItem{"put", m.Put.ToRawInfo()})
	}
	// &{Name:put Type:Operation StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Post != nil {
		info = append(info, yaml.MapItem{"post", m.Post.ToRawInfo()})
	}
	// &{Name:post Type:Operation StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Delete != nil {
		info = append(info, yaml.MapItem{"delete", m.Delete.ToRawInfo()})
	}
	// &{Name:delete Type:Operation StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Options != nil {
		info = append(info, yaml.MapItem{"options", m.Options.ToRawInfo()})
	}
	// &{Name:options Type:Operation StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Head != nil {
		info = append(info, yaml.MapItem{"head", m.Head.ToRawInfo()})
	}
	// &{Name:head Type:Operation StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Patch != nil {
		info = append(info, yaml.MapItem{"patch", m.Patch.ToRawInfo()})
	}
	// &{Name:patch Type:Operation StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if len(m.Parameters) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Parameters {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"parameters", items})
	}
	// &{Name:parameters Type:ParametersItem StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:The parameters needed to send a valid API call.}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of PathParameterSubSchema suitable for JSON or YAML export.
func (m *PathParameterSubSchema) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Required != false {
		info = append(info, yaml.MapItem{"required", m.Required})
	}
	if m.In != "" {
		info = append(info, yaml.MapItem{"in", m.In})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	if m.Type != "" {
		info = append(info, yaml.MapItem{"type", m.Type})
	}
	if m.Format != "" {
		info = append(info, yaml.MapItem{"format", m.Format})
	}
	if m.Items != nil {
		info = append(info, yaml.MapItem{"items", m.Items.ToRawInfo()})
	}
	// &{Name:items Type:PrimitivesItems StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.CollectionFormat != "" {
		info = append(info, yaml.MapItem{"collectionFormat", m.CollectionFormat})
	}
	if m.Default != nil {
		info = append(info, yaml.MapItem{"default", m.Default.ToRawInfo()})
	}
	// &{Name:default Type:Any StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Maximum != 0.0 {
		info = append(info, yaml.MapItem{"maximum", m.Maximum})
	}
	if m.ExclusiveMaximum != false {
		info = append(info, yaml.MapItem{"exclusiveMaximum", m.ExclusiveMaximum})
	}
	if m.Minimum != 0.0 {
		info = append(info, yaml.MapItem{"minimum", m.Minimum})
	}
	if m.ExclusiveMinimum != false {
		info = append(info, yaml.MapItem{"exclusiveMinimum", m.ExclusiveMinimum})
	}
	if m.MaxLength != 0 {
		info = append(info, yaml.MapItem{"maxLength", m.MaxLength})
	}
	if m.MinLength != 0 {
		info = append(info, yaml.MapItem{"minLength", m.MinLength})
	}
	if m.Pattern != "" {
		info = append(info, yaml.MapItem{"pattern", m.Pattern})
	}
	if m.MaxItems != 0 {
		info = append(info, yaml.MapItem{"maxItems", m.MaxItems})
	}
	if m.MinItems != 0 {
		info = append(info, yaml.MapItem{"minItems", m.MinItems})
	}
	if m.UniqueItems != false {
		info = append(info, yaml.MapItem{"uniqueItems", m.UniqueItems})
	}
	if len(m.Enum) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Enum {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"enum", items})
	}
	// &{Name:enum Type:Any StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if m.MultipleOf != 0.0 {
		info = append(info, yaml.MapItem{"multipleOf", m.MultipleOf})
	}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Paths suitable for JSON or YAML export.
func (m *Paths) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	if m.Path != nil {
		for _, item := range m.Path {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:Path Type:NamedPathItem StringEnumValues:[] MapType:PathItem Repeated:true Pattern:^/ Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of PrimitivesItems suitable for JSON or YAML export.
func (m *PrimitivesItems) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Type != "" {
		info = append(info, yaml.MapItem{"type", m.Type})
	}
	if m.Format != "" {
		info = append(info, yaml.MapItem{"format", m.Format})
	}
	if m.Items != nil {
		info = append(info, yaml.MapItem{"items", m.Items.ToRawInfo()})
	}
	// &{Name:items Type:PrimitivesItems StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.CollectionFormat != "" {
		info = append(info, yaml.MapItem{"collectionFormat", m.CollectionFormat})
	}
	if m.Default != nil {
		info = append(info, yaml.MapItem{"default", m.Default.ToRawInfo()})
	}
	// &{Name:default Type:Any StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Maximum != 0.0 {
		info = append(info, yaml.MapItem{"maximum", m.Maximum})
	}
	if m.ExclusiveMaximum != false {
		info = append(info, yaml.MapItem{"exclusiveMaximum", m.ExclusiveMaximum})
	}
	if m.Minimum != 0.0 {
		info = append(info, yaml.MapItem{"minimum", m.Minimum})
	}
	if m.ExclusiveMinimum != false {
		info = append(info, yaml.MapItem{"exclusiveMinimum", m.ExclusiveMinimum})
	}
	if m.MaxLength != 0 {
		info = append(info, yaml.MapItem{"maxLength", m.MaxLength})
	}
	if m.MinLength != 0 {
		info = append(info, yaml.MapItem{"minLength", m.MinLength})
	}
	if m.Pattern != "" {
		info = append(info, yaml.MapItem{"pattern", m.Pattern})
	}
	if m.MaxItems != 0 {
		info = append(info, yaml.MapItem{"maxItems", m.MaxItems})
	}
	if m.MinItems != 0 {
		info = append(info, yaml.MapItem{"minItems", m.MinItems})
	}
	if m.UniqueItems != false {
		info = append(info, yaml.MapItem{"uniqueItems", m.UniqueItems})
	}
	if len(m.Enum) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Enum {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"enum", items})
	}
	// &{Name:enum Type:Any StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if m.MultipleOf != 0.0 {
		info = append(info, yaml.MapItem{"multipleOf", m.MultipleOf})
	}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Properties suitable for JSON or YAML export.
func (m *Properties) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedSchema StringEnumValues:[] MapType:Schema Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of QueryParameterSubSchema suitable for JSON or YAML export.
func (m *QueryParameterSubSchema) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Required != false {
		info = append(info, yaml.MapItem{"required", m.Required})
	}
	if m.In != "" {
		info = append(info, yaml.MapItem{"in", m.In})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	if m.AllowEmptyValue != false {
		info = append(info, yaml.MapItem{"allowEmptyValue", m.AllowEmptyValue})
	}
	if m.Type != "" {
		info = append(info, yaml.MapItem{"type", m.Type})
	}
	if m.Format != "" {
		info = append(info, yaml.MapItem{"format", m.Format})
	}
	if m.Items != nil {
		info = append(info, yaml.MapItem{"items", m.Items.ToRawInfo()})
	}
	// &{Name:items Type:PrimitivesItems StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.CollectionFormat != "" {
		info = append(info, yaml.MapItem{"collectionFormat", m.CollectionFormat})
	}
	if m.Default != nil {
		info = append(info, yaml.MapItem{"default", m.Default.ToRawInfo()})
	}
	// &{Name:default Type:Any StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Maximum != 0.0 {
		info = append(info, yaml.MapItem{"maximum", m.Maximum})
	}
	if m.ExclusiveMaximum != false {
		info = append(info, yaml.MapItem{"exclusiveMaximum", m.ExclusiveMaximum})
	}
	if m.Minimum != 0.0 {
		info = append(info, yaml.MapItem{"minimum", m.Minimum})
	}
	if m.ExclusiveMinimum != false {
		info = append(info, yaml.MapItem{"exclusiveMinimum", m.ExclusiveMinimum})
	}
	if m.MaxLength != 0 {
		info = append(info, yaml.MapItem{"maxLength", m.MaxLength})
	}
	if m.MinLength != 0 {
		info = append(info, yaml.MapItem{"minLength", m.MinLength})
	}
	if m.Pattern != "" {
		info = append(info, yaml.MapItem{"pattern", m.Pattern})
	}
	if m.MaxItems != 0 {
		info = append(info, yaml.MapItem{"maxItems", m.MaxItems})
	}
	if m.MinItems != 0 {
		info = append(info, yaml.MapItem{"minItems", m.MinItems})
	}
	if m.UniqueItems != false {
		info = append(info, yaml.MapItem{"uniqueItems", m.UniqueItems})
	}
	if len(m.Enum) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Enum {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"enum", items})
	}
	// &{Name:enum Type:Any StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if m.MultipleOf != 0.0 {
		info = append(info, yaml.MapItem{"multipleOf", m.MultipleOf})
	}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Response suitable for JSON or YAML export.
func (m *Response) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Schema != nil {
		info = append(info, yaml.MapItem{"schema", m.Schema.ToRawInfo()})
	}
	// &{Name:schema Type:SchemaItem StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Headers != nil {
		info = append(info, yaml.MapItem{"headers", m.Headers.ToRawInfo()})
	}
	// &{Name:headers Type:Headers StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Examples != nil {
		info = append(info, yaml.MapItem{"examples", m.Examples.ToRawInfo()})
	}
	// &{Name:examples Type:Examples StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of ResponseDefinitions suitable for JSON or YAML export.
func (m *ResponseDefinitions) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedResponse StringEnumValues:[] MapType:Response Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of ResponseValue suitable for JSON or YAML export.
func (m *ResponseValue) ToRawInfo() interface{} {
	// ONE OF WRAPPER
	// ResponseValue
	// {Name:response Type:Response StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v0 := m.GetResponse()
	if v0 != nil {
		return v0.ToRawInfo()
	}
	// {Name:jsonReference Type:JsonReference StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v1 := m.GetJsonReference()
	if v1 != nil {
		return v1.ToRawInfo()
	}
	return nil
}

// ToRawInfo returns a description of Responses suitable for JSON or YAML export.
func (m *Responses) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.ResponseCode != nil {
		for _, item := range m.ResponseCode {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:ResponseCode Type:NamedResponseValue StringEnumValues:[] MapType:ResponseValue Repeated:true Pattern:^([0-9]{3})$|^(default)$ Implicit:true Description:}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Schema suitable for JSON or YAML export.
func (m *Schema) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.XRef != "" {
		info = append(info, yaml.MapItem{"$ref", m.XRef})
	}
	if m.Format != "" {
		info = append(info, yaml.MapItem{"format", m.Format})
	}
	if m.Title != "" {
		info = append(info, yaml.MapItem{"title", m.Title})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Default != nil {
		info = append(info, yaml.MapItem{"default", m.Default.ToRawInfo()})
	}
	// &{Name:default Type:Any StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.MultipleOf != 0.0 {
		info = append(info, yaml.MapItem{"multipleOf", m.MultipleOf})
	}
	if m.Maximum != 0.0 {
		info = append(info, yaml.MapItem{"maximum", m.Maximum})
	}
	if m.ExclusiveMaximum != false {
		info = append(info, yaml.MapItem{"exclusiveMaximum", m.ExclusiveMaximum})
	}
	if m.Minimum != 0.0 {
		info = append(info, yaml.MapItem{"minimum", m.Minimum})
	}
	if m.ExclusiveMinimum != false {
		info = append(info, yaml.MapItem{"exclusiveMinimum", m.ExclusiveMinimum})
	}
	if m.MaxLength != 0 {
		info = append(info, yaml.MapItem{"maxLength", m.MaxLength})
	}
	if m.MinLength != 0 {
		info = append(info, yaml.MapItem{"minLength", m.MinLength})
	}
	if m.Pattern != "" {
		info = append(info, yaml.MapItem{"pattern", m.Pattern})
	}
	if m.MaxItems != 0 {
		info = append(info, yaml.MapItem{"maxItems", m.MaxItems})
	}
	if m.MinItems != 0 {
		info = append(info, yaml.MapItem{"minItems", m.MinItems})
	}
	if m.UniqueItems != false {
		info = append(info, yaml.MapItem{"uniqueItems", m.UniqueItems})
	}
	if m.MaxProperties != 0 {
		info = append(info, yaml.MapItem{"maxProperties", m.MaxProperties})
	}
	if m.MinProperties != 0 {
		info = append(info, yaml.MapItem{"minProperties", m.MinProperties})
	}
	if len(m.Required) != 0 {
		info = append(info, yaml.MapItem{"required", m.Required})
	}
	if len(m.Enum) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.Enum {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"enum", items})
	}
	// &{Name:enum Type:Any StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if m.AdditionalProperties != nil {
		info = append(info, yaml.MapItem{"additionalProperties", m.AdditionalProperties.ToRawInfo()})
	}
	// &{Name:additionalProperties Type:AdditionalPropertiesItem StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Type != nil {
		if len(m.Type.Value) == 1 {
			info = append(info, yaml.MapItem{"type", m.Type.Value[0]})
		} else {
			info = append(info, yaml.MapItem{"type", m.Type.Value})
		}
	}
	// &{Name:type Type:TypeItem StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Items != nil {
		items := make([]interface{}, 0)
		for _, item := range m.Items.Schema {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"items", items[0]})
	}
	// &{Name:items Type:ItemsItem StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if len(m.AllOf) != 0 {
		items := make([]interface{}, 0)
		for _, item := range m.AllOf {
			items = append(items, item.ToRawInfo())
		}
		info = append(info, yaml.MapItem{"allOf", items})
	}
	// &{Name:allOf Type:Schema StringEnumValues:[] MapType: Repeated:true Pattern: Implicit:false Description:}
	if m.Properties != nil {
		info = append(info, yaml.MapItem{"properties", m.Properties.ToRawInfo()})
	}
	// &{Name:properties Type:Properties StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Discriminator != "" {
		info = append(info, yaml.MapItem{"discriminator", m.Discriminator})
	}
	if m.ReadOnly != false {
		info = append(info, yaml.MapItem{"readOnly", m.ReadOnly})
	}
	if m.Xml != nil {
		info = append(info, yaml.MapItem{"xml", m.Xml.ToRawInfo()})
	}
	// &{Name:xml Type:Xml StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.ExternalDocs != nil {
		info = append(info, yaml.MapItem{"externalDocs", m.ExternalDocs.ToRawInfo()})
	}
	// &{Name:externalDocs Type:ExternalDocs StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Example != nil {
		info = append(info, yaml.MapItem{"example", m.Example.ToRawInfo()})
	}
	// &{Name:example Type:Any StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of SchemaItem suitable for JSON or YAML export.
func (m *SchemaItem) ToRawInfo() interface{} {
	// ONE OF WRAPPER
	// SchemaItem
	// {Name:schema Type:Schema StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v0 := m.GetSchema()
	if v0 != nil {
		return v0.ToRawInfo()
	}
	// {Name:fileSchema Type:FileSchema StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v1 := m.GetFileSchema()
	if v1 != nil {
		return v1.ToRawInfo()
	}
	return nil
}

// ToRawInfo returns a description of SecurityDefinitions suitable for JSON or YAML export.
func (m *SecurityDefinitions) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedSecurityDefinitionsItem StringEnumValues:[] MapType:SecurityDefinitionsItem Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of SecurityDefinitionsItem suitable for JSON or YAML export.
func (m *SecurityDefinitionsItem) ToRawInfo() interface{} {
	// ONE OF WRAPPER
	// SecurityDefinitionsItem
	// {Name:basicAuthenticationSecurity Type:BasicAuthenticationSecurity StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v0 := m.GetBasicAuthenticationSecurity()
	if v0 != nil {
		return v0.ToRawInfo()
	}
	// {Name:apiKeySecurity Type:ApiKeySecurity StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v1 := m.GetApiKeySecurity()
	if v1 != nil {
		return v1.ToRawInfo()
	}
	// {Name:oauth2ImplicitSecurity Type:Oauth2ImplicitSecurity StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v2 := m.GetOauth2ImplicitSecurity()
	if v2 != nil {
		return v2.ToRawInfo()
	}
	// {Name:oauth2PasswordSecurity Type:Oauth2PasswordSecurity StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v3 := m.GetOauth2PasswordSecurity()
	if v3 != nil {
		return v3.ToRawInfo()
	}
	// {Name:oauth2ApplicationSecurity Type:Oauth2ApplicationSecurity StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v4 := m.GetOauth2ApplicationSecurity()
	if v4 != nil {
		return v4.ToRawInfo()
	}
	// {Name:oauth2AccessCodeSecurity Type:Oauth2AccessCodeSecurity StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	v5 := m.GetOauth2AccessCodeSecurity()
	if v5 != nil {
		return v5.ToRawInfo()
	}
	return nil
}

// ToRawInfo returns a description of SecurityRequirement suitable for JSON or YAML export.
func (m *SecurityRequirement) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedStringArray StringEnumValues:[] MapType:StringArray Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of StringArray suitable for JSON or YAML export.
func (m *StringArray) ToRawInfo() interface{} {
	return m.Value
}

// ToRawInfo returns a description of Tag suitable for JSON or YAML export.
func (m *Tag) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.ExternalDocs != nil {
		info = append(info, yaml.MapItem{"externalDocs", m.ExternalDocs.ToRawInfo()})
	}
	// &{Name:externalDocs Type:ExternalDocs StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of TypeItem suitable for JSON or YAML export.
func (m *TypeItem) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if len(m.Value) != 0 {
		info = append(info, yaml.MapItem{"value", m.Value})
	}
	return info
}

// ToRawInfo returns a description of VendorExtension suitable for JSON or YAML export.
func (m *VendorExtension) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Xml suitable for JSON or YAML export.
func (m *Xml) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	if m.Namespace != "" {
		info = append(info, yaml.MapItem{"namespace", m.Namespace})
	}
	if m.Prefix != "" {
		info = append(info, yaml.MapItem{"prefix", m.Prefix})
	}
	if m.Attribute != false {
		info = append(info, yaml.MapItem{"attribute", m.Attribute})
	}
	if m.Wrapped != false {
		info = append(info, yaml.MapItem{"wrapped", m.Wrapped})
	}
	if m.VendorExtension != nil {
		for _, item := range m.VendorExtension {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:VendorExtension Type:NamedAny StringEnumValues:[] MapType:Any Repeated:true Pattern:^x- Implicit:true Description:}
	return info
}
