#ifndef Analyzer_h
#define Analyzer_h

using namespace std;

namespace doctorj
{
    class Error;
    class Reporter;

    /**
     * Performs generic analysis, and forwards complaints to the reporter.
     */
    class Analyzer
    {
    public:
        /**
         * Uses the given reporter, strict flag, and modifiers.
         */
        Analyzer(Reporter* const reporter);

        virtual ~Analyzer();

        /**
         * Process an error.
         */
        virtual void process(Error* const err) const;

        /**
         * Returns the reporter.
         */
        virtual Reporter* reporter() const;

    protected:

        /**
         * Not useful for checking code. Only for invoking methods associated as
         * an analyzer, not the code itself.
         */
        Analyzer();

        /**
         * Where errors are sent for reporting.
         */
        Reporter* const reporter_;

    };
}

#endif //! Analyzer_h
