#ifndef ContextReporter_h
#define ContextReporter_h

#ifndef Reporter_h
#include "Reporter.h"
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

#ifndef std_string
#define std_string
#include <string>
#endif

using namespace std;

namespace doctorj
{
    class File;
    class ReportedError;

    /**
     * Writes error messages in a long format.
     */
    class ContextReporter : public Reporter
    {
    public:
        ContextReporter(ostream& os);

        virtual ~ContextReporter();

    protected:

        /**
         * Produces the error for the given item in the context format.
         */
        virtual void writeError(const ReportedError& err);

        /**
         * Highlights the region for the given line.
         */
        void underline(char* startOfLine, char* startPos, char* endPos);

        /**
         * Writes "<---..." to the end of the given line.
         */
        void markToEndOfLine(char* startOfLine, char* startPos);
        
        /**
         * Writes "...--->" to the start position.
         */
        void markToStartPosition(char* startOfLine, char* startPos);

        /**
         * Writes a line in the long format.
         */
        void writeLine(int line, File* const file);

        /**
         * Indents with the given character from the start position through the
         * end position.
         */
        void indent(char* start, char* end, char ch);

    private:

        /**
         * The last file that was output.
         */
        File* lastFile_;

    };
}

        
#endif //! ContextReporter_h
