#ifndef ProcessorSet_h
#define ProcessorSet_h

#ifndef Processor_h
#include "Processor.h"
#endif

#ifndef std_vector
#define std_vector
#include <vector>
#endif

using namespace std;

namespace doctorj
{
    class Reporter;
    class Rule;

    /**
     * Applies a list of rules to compilation units (not to Projects as a
     * whole).
     */
    class ProcessorSet : public Processor
    {
    public:
        ProcessorSet(Reporter* const reporter);

        virtual ~ProcessorSet();

        virtual void addRule(Rule* const rule);

        virtual void process(AstCompilationUnit* const cu);

        virtual void process(AstCompilationUnitEmpty* const cu);

        virtual void process(AstCompilationUnitImp* const cu);

        virtual void process(AstCompilationUnitImpTypes* const cu);

        virtual void process(AstCompilationUnitPkg* const cu);

        virtual void process(AstCompilationUnitPkgImp* const cu);

        virtual void process(AstCompilationUnitPkgImpTypes* const cu);

        virtual void process(AstCompilationUnitPkgTypes* const cu);

        virtual void process(AstCompilationUnitTypes* const cu);

    private:
        vector<Rule*> rules_;

        Reporter* const reporter_;

    };
}

#endif //! ProcessorSet_h
