#ifndef HierarchyPrinter_h
#define HierarchyPrinter_h

#ifndef Processor_h
#include "Processor.h"
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

using namespace std;


namespace doctorj
{
    class AstProject;
    class AstNode;
    class AstItem;
    class AstValue;

    class HierarchyPrinter : public Processor 
    {
    public:

        virtual ~HierarchyPrinter();
        
        /**
         * Processes an AstProject.
         */
        virtual void process(AstProject* const p);
        
    protected:
        
        /**
         * Indents.
         */
        void indent(ostream& os, int level);
        
        /**
         * Prints a node.
         */
        virtual void print(AstNode* const n, int level = 0) = 0;
        
        /**
         * Prints an item.
         */
        virtual void print(AstItem* const i, int level = 0) = 0;
        
    };
}

#endif //! HierarchyPrinter_h
