#ifndef HierarchyXMLPrinter_h
#include "HierarchyXMLPrinter.h"
#endif

#ifndef File_h
#include "File.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

using namespace std;
using namespace doctorj;


HierarchyXMLPrinter::HierarchyXMLPrinter()
{
    cout << "<?xml version=\"1.0\"?>" << endl;
    cout << "<DoctorJ>" << endl;
}

HierarchyXMLPrinter::~HierarchyXMLPrinter()
{
    cout << "</DoctorJ>" << endl;
}

void HierarchyXMLPrinter::process(AstProject* const p)
{
    // Start with level 1, to compensate for the <DoctorJ>...</DoctorJ> block.
    print(p, 1);
}

void HierarchyXMLPrinter::print(AstNode* const n, int level /* = 0 */)
{
    indent(cout, level);
    
    cout << "<" << n->type() << "> ";
    cout << endl;

    // show all the components, and so on
    list<AstItem*>::const_iterator start = n->components().begin();
    list<AstItem*>::const_iterator stop = n->components().end();
    int i = 0;
    for (list<AstItem*>::const_iterator it = start; it != stop; ++it) {
        AstItem* item = *it;
        
        if (item == NULL) {
            // this should not happen
            indent(cout, level + 1);
            cout << "component #" << i << " = null" << endl;
        }
        else {

            // Poor man's double dispatch

            AstNode* node = dynamic_cast<AstNode*>(item);
            if (node) {
                print(node, level + 1);
            }
            else {
                print(item, level + 1);
            }
        }
        ++i;
    }

    indent(cout, level);
    cout << "</" << n->type() << ">" << endl;
}

void HierarchyXMLPrinter::print(AstItem* const i, int level /* = 0 */)
{
    indent(cout, level);
    cout << "<" << i->type() << " ";
    
    cout << "file=\""   << i->sourceFile()->name() << "\" ";
    cout << "line=\""   << i->line() << "\" ";
    cout << "column=\"" << i->column() << "\" ";

    // In general, I disdain this type of code, but here I am, writing it
    // myself. Go figure.

    AstValue* value = dynamic_cast<AstValue*>(i);
    if (value) {
        // end is the _last_ character, so take off one.
        int end = i->column() + i->text().length() - 1;
        cout << "endcolumn=\"" << end << "\" ";
        bool quotes = dynamic_cast<AstStringLiteral*>(value) == NULL;
        cout << "value=";
        if (quotes) {
            cout << '"';
        }
        cout << i->text();
        if (quotes) {
            cout << '"';
        }

        cout << " ";
    }

    cout << "/>";
    cout << endl;
}
