#ifndef ClassInterfaceDocumentationAnalyzer_h
#include "ClassInterfaceDocumentationAnalyzer.h"
#endif

#ifndef DocumentationErrors_h
#include "DocumentationErrors.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef JavadocTags_h
#include "JavadocTags.h"
#endif

#ifndef DocDebug_h
#include "DocDebug.h"
#endif

using namespace doctorj;

ClassInterfaceDocumentationAnalyzer::ClassInterfaceDocumentationAnalyzer(Reporter* const reporter,
                                                                         AstModifierList* const modifiers) :
        ItemDocumentationAnalyzer(reporter, modifiers), seenVersion_(false)
{
}

ClassInterfaceDocumentationAnalyzer::ClassInterfaceDocumentationAnalyzer()
{
}

ClassInterfaceDocumentationAnalyzer::~ClassInterfaceDocumentationAnalyzer()
{
}

bool ClassInterfaceDocumentationAnalyzer::handleTag(AstTaggedComment* const tc) 
{
    string tag = tc->tag();
    if (tag == JavadocTags::VERSION_) {
        checkVersion(tc);
        return true;
    }
    else if (tag == JavadocTags::AUTHOR) {
        checkAuthor(tc);
        return true;
    }
    else {
        return ItemDocumentationAnalyzer::handleTag(tc);
    }
}

void ClassInterfaceDocumentationAnalyzer::checkVersion(AstTaggedComment* const tc) 
{
    DEBUG_DOCUMENTATION_ANALYZER(cout << "CIDOA  checking version" << endl);
    if (seenVersion_) {
        ErrorMultipleVersionTags err(reporter(), tc);
        err.process();
    }
    else if (tc->countTargets() <= 0) {
        ErrorVersionWithoutText err(reporter(), tc);
        err.process();
    }

    seenVersion_ = true;    
}

void ClassInterfaceDocumentationAnalyzer::checkAuthor(AstTaggedComment* const tc) 
{
    if (tc->countTargets() <= 0) {
        ErrorAuthorWithoutNameText err(reporter(), tc);
        err.process();
    }
}
