#ifndef DocumentationAnalyzer_h
#include "DocumentationAnalyzer.h"
#endif

#ifndef MethodDocumentationAnalyzer_h
#include "MethodDocumentationAnalyzer.h"
#endif

#ifndef ConstructorDocumentationAnalyzer_h
#include "ConstructorDocumentationAnalyzer.h"
#endif

#ifndef FieldDocumentationAnalyzer_h
#include "FieldDocumentationAnalyzer.h"
#endif

#ifndef ClassDocumentationAnalyzer_h
#include "ClassDocumentationAnalyzer.h"
#endif

#ifndef InterfaceDocumentationAnalyzer_h
#include "InterfaceDocumentationAnalyzer.h"
#endif

using namespace doctorj;

DocumentationAnalyzer::DocumentationAnalyzer(Reporter* const reporter) : reporter_(reporter)
{
}

DocumentationAnalyzer::~DocumentationAnalyzer()
{
}

void DocumentationAnalyzer::process(AstClassDeclarationModsBaseless* const c)
{
    ClassDocumentationAnalyzer cda(reporter_, c, c->getIdentifier(), c->getModifierList());
    traverse(c);
}

void DocumentationAnalyzer::process(AstClassDeclarationModsExtends* const c)
{
    ClassDocumentationAnalyzer cda(reporter_, c, c->getIdentifier(), c->getModifierList());
    traverse(c);
}

void DocumentationAnalyzer::process(AstClassDeclarationModsExtendsImplements* const c)
{
    ClassDocumentationAnalyzer cda(reporter_, c, c->getIdentifier(), c->getModifierList());
    traverse(c);
}

void DocumentationAnalyzer::process(AstClassDeclarationModsImplements* const c)
{
    ClassDocumentationAnalyzer cda(reporter_, c, c->getIdentifier(), c->getModifierList());
    traverse(c);
}

void DocumentationAnalyzer::process(AstClassDeclarationNoModsBaseless* const c)
{
    ClassDocumentationAnalyzer cda(reporter_, c, c->getIdentifier(), NULL);
    traverse(c);
}

void DocumentationAnalyzer::process(AstClassDeclarationNoModsExtends* const c)
{
    ClassDocumentationAnalyzer cda(reporter_, c, c->getIdentifier(), NULL);
    traverse(c);
}

void DocumentationAnalyzer::process(AstClassDeclarationNoModsExtendsImplements* const c)
{
    ClassDocumentationAnalyzer cda(reporter_, c, c->getIdentifier(), NULL);
    traverse(c);
}

void DocumentationAnalyzer::process(AstClassDeclarationNoModsImplements* const c)
{
    ClassDocumentationAnalyzer cda(reporter_, c, c->getIdentifier(), NULL);
    traverse(c);
}


void DocumentationAnalyzer::process(AstClassMemberDeclarationNoModsNoExtendsNoImplements* const c)
{
    ClassDocumentationAnalyzer cda(reporter_, c, c->getIdentifier(), c->getModifierList());
    traverse(c);
}

void DocumentationAnalyzer::process(AstClassMemberDeclarationNoModsNoExtendsImplements* const c)
{
    ClassDocumentationAnalyzer cda(reporter_, c, c->getIdentifier(), c->getModifierList());
    traverse(c);
}

void DocumentationAnalyzer::process(AstClassMemberDeclarationNoModsExtendsNoImplements* const c)
{
    ClassDocumentationAnalyzer cda(reporter_, c, c->getIdentifier(), c->getModifierList());
    traverse(c);
}

void DocumentationAnalyzer::process(AstClassMemberDeclarationNoModsExtendsImplements* const c)
{
    ClassDocumentationAnalyzer cda(reporter_, c, c->getIdentifier(), c->getModifierList());
    traverse(c);
}

void DocumentationAnalyzer::process(AstClassMemberDeclarationModsNoExtendsNoImplements* const c)
{
    ClassDocumentationAnalyzer cda(reporter_, c, c->getIdentifier(), c->getModifierList());
    traverse(c);
}

void DocumentationAnalyzer::process(AstClassMemberDeclarationModsNoExtendsImplements* const c)
{
    ClassDocumentationAnalyzer cda(reporter_, c, c->getIdentifier(), c->getModifierList());
    traverse(c);
}

void DocumentationAnalyzer::process(AstClassMemberDeclarationModsExtendsNoImplements* const c)
{
    ClassDocumentationAnalyzer cda(reporter_, c, c->getIdentifier(), c->getModifierList());
    traverse(c);
}

void DocumentationAnalyzer::process(AstClassMemberDeclarationModsExtendsImplements* const c)
{
    ClassDocumentationAnalyzer cda(reporter_, c, c->getIdentifier(), c->getModifierList());
    traverse(c);
}

void DocumentationAnalyzer::process(AstConstructorDeclarationModsNoThrows* const c)
{
    ConstructorDocumentationAnalyzer cda(reporter_, 
                                         c->getConstructorDeclarator(),
                                         c->getModifierList(), 
                                         c->getConstructorDeclarator()->getFormalParameterList(),
                                         NULL);
    traverse(c);
}

void DocumentationAnalyzer::process(AstConstructorDeclarationModsThrows* const c)
{
    ConstructorDocumentationAnalyzer cda(reporter_, 
                                         c->getConstructorDeclarator(),
                                         c->getModifierList(), 
                                         c->getConstructorDeclarator()->getFormalParameterList(),
                                         c->getThrowsNameList());
    traverse(c);
}

void DocumentationAnalyzer::process(AstConstructorDeclarationNoModsNoThrows* const c)
{
    ConstructorDocumentationAnalyzer cda(reporter_, 
                                         c->getConstructorDeclarator(),
                                         NULL, 
                                         c->getConstructorDeclarator()->getFormalParameterList(),
                                         NULL);
    traverse(c);
}

void DocumentationAnalyzer::process(AstConstructorDeclarationNoModsThrows* const c)
{
    ConstructorDocumentationAnalyzer cda(reporter_, 
                                         c->getConstructorDeclarator(),
                                         NULL,
                                         c->getConstructorDeclarator()->getFormalParameterList(),
                                         c->getThrowsNameList());
    traverse(c);
}

void DocumentationAnalyzer::process(AstFieldDeclarationMods* const fd)
{
    FieldDocumentationAnalyzer fda(reporter_, fd, fd->getModifierList());
    traverse(fd);
}

void DocumentationAnalyzer::process(AstFieldDeclarationNoMods* const fd)
{
    FieldDocumentationAnalyzer fda(reporter_, fd, NULL);
    traverse(fd);
}

void DocumentationAnalyzer::process(AstInterfaceDeclarationModsExtends* const i)
{
    InterfaceDocumentationAnalyzer ida(reporter_, i, i->getModifierList());
    traverse(i);
}

void DocumentationAnalyzer::process(AstInterfaceDeclarationModsNoExtends* const i)
{
    InterfaceDocumentationAnalyzer ida(reporter_, i, i->getModifierList());
    traverse(i);
}

void DocumentationAnalyzer::process(AstInterfaceDeclarationNoModsExtends* const i)
{
    InterfaceDocumentationAnalyzer ida(reporter_, i, NULL);
    traverse(i);
}

void DocumentationAnalyzer::process(AstInterfaceDeclarationNoModsNoExtends* const i)
{
    InterfaceDocumentationAnalyzer ida(reporter_, i, NULL);
    traverse(i);
}

void DocumentationAnalyzer::process(AstMethodHeaderTypeModsNoThrows* const m)
{
    MethodDocumentationAnalyzer mda(reporter_,
                                    m,
                                    m->getType(), 
                                    m->getModifierList(), 
                                    m->getMethodDeclarator()->getFormalParameterList(), 
                                    NULL);
    traverse(m);
}

void DocumentationAnalyzer::process(AstMethodHeaderTypeModsThrows* const m)
{
    MethodDocumentationAnalyzer mda(reporter_, 
                                    m, 
                                    m->getType(), 
                                    m->getModifierList(), 
                                    m->getMethodDeclarator()->getFormalParameterList(), 
                                    m->getThrowsNameList());
    traverse(m);
}

void DocumentationAnalyzer::process(AstMethodHeaderTypeNoModsNoThrows* const m)
{
    MethodDocumentationAnalyzer mda(reporter_,
                                    m,
                                    m->getType(), 
                                    NULL, 
                                    m->getMethodDeclarator()->getFormalParameterList(), 
                                    NULL);
    traverse(m);
}

void DocumentationAnalyzer::process(AstMethodHeaderTypeNoModsThrows* const m)
{
    MethodDocumentationAnalyzer mda(reporter_, 
                                    m, 
                                    m->getType(), 
                                    NULL, 
                                    m->getMethodDeclarator()->getFormalParameterList(), 
                                    m->getThrowsNameList());
    traverse(m);
}

void DocumentationAnalyzer::process(AstMethodHeaderVoidModsNoThrows* const m)
{
    MethodDocumentationAnalyzer mda(reporter_,
                                    m,
                                    NULL,
                                    m->getModifierList(), 
                                    m->getMethodDeclarator()->getFormalParameterList(), 
                                    NULL);
    traverse(m);
}

void DocumentationAnalyzer::process(AstMethodHeaderVoidModsThrows* const m)
{
    MethodDocumentationAnalyzer mda(reporter_, 
                                    m,
                                    NULL,
                                    m->getModifierList(), 
                                    m->getMethodDeclarator()->getFormalParameterList(), 
                                    m->getThrowsNameList());
    traverse(m);
}

void DocumentationAnalyzer::process(AstMethodHeaderVoidNoModsNoThrows* const m)
{
    MethodDocumentationAnalyzer mda(reporter_,
                                    m,
                                    NULL, 
                                    NULL, 
                                    m->getMethodDeclarator()->getFormalParameterList(), 
                                    NULL);
    traverse(m);
}

void DocumentationAnalyzer::process(AstMethodHeaderVoidNoModsThrows* const m)
{
    MethodDocumentationAnalyzer mda(reporter_,
                                    m,
                                    NULL,
                                    NULL, 
                                    m->getMethodDeclarator()->getFormalParameterList(), 
                                    m->getThrowsNameList());
    traverse(m);
}
