#ifndef DocumentationAnalyzerApp_h
#include "DocumentationAnalyzerApp.h"
#endif

#ifndef DocumentationAnalyzer_h
#include "DocumentationAnalyzer.h"
#endif

#ifndef UserPreferences_h
#include "UserPreferences.h"
#endif

#ifndef DocUserPreferences_h
#include "DocUserPreferences.h"
#endif

#ifndef ContextReporter_h
#include "ContextReporter.h"
#endif

#ifndef TerseReporter_h
#include "TerseReporter.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef DocErrorRegistry_h
#include "DocErrorRegistry.h"
#endif

#ifndef DocDebug_h
#include "DocDebug.h"
#endif

using namespace doctorj;

template < class T >
static void addConfigOption(yagol::AppOptionSet* const opts,
                            const string& name,
                            const string& desc,
                            T* const value)
{
    yagol::Option* opt = opts->addOption(name, desc, value);
    opt->setConfigOnly(true);
}

REGISTER_DEBUG_OPTION('d', "Documentation analyzer");

DocumentationAnalyzerApp::DocumentationAnalyzerApp() : App("docj", "Javadoc analyzer")
{
    buildOptions();
}

DocumentationAnalyzerApp::~DocumentationAnalyzerApp()
{
}

void DocumentationAnalyzerApp::addOptions(yagol::AppOptionSet* const opts)
{
    UserPreferences* prefs = UserPreferences::get();
    DocUserPreferences* docprefs = DocUserPreferences::get();
    
    addConfigOption(opts,
                    "tags.custom",
                    "User-defined Javadoc tags",
                    &(docprefs->userDefinedTags));

    addConfigOption(opts,
                    "dictionaries",
                    "The dictionaries to be used",
                    &(docprefs->dictionaries));

    addConfigOption(opts,
                    "words.valid",
                    "Words that are valid for spell-checking",
                    &(docprefs->validWords));

    // ----- author ---------------------------------------

    addConfigOption(opts,
                    "default.author.name",
                    "Default author name",
                    &(docprefs->defaultAuthorName));

    // ----- version --------------------------------------

    addConfigOption(opts,
                    "default.version",
                    "Default version",
                    &(docprefs->defaultVersion));

    // ----- class ----------------------------------------

    addConfigOption(opts,
                    "default.class.description",
                    "Default class description",
                    &(docprefs->defaultClassDescription));

    // ----- interface ------------------------------------

    addConfigOption(opts,
                    "default.interface.description",
                    "Default interface description",
                    &(docprefs->defaultInterfaceDescription));


    // ----- field ----------------------------------------

    addConfigOption(opts,
                    "default.field.description",
                    "Default field description",
                    &(docprefs->defaultFieldDescription));

    // ----- method ---------------------------------------

    addConfigOption(opts,
                    "default.method.description",
                    "Default method description",
                    &(docprefs->defaultMethodDescription));

    // ----- parameter ------------------------------------

    addConfigOption(opts,
                    "default.parameter.description",
                    "Default parameter description",
                    &(docprefs->defaultParameterDescription));
    
    // ----- exception ------------------------------------

    addConfigOption(opts,
                    "default.exception.description",
                    "Default exception description",
                    &(docprefs->defaultExceptionDescription));

    // ----- constructor ----------------------------------

    addConfigOption(opts,
                    "default.constructor.description",
                    "Default constructor description",
                    &(docprefs->defaultConstructorDescription));

    addContextOption();
}

void DocumentationAnalyzerApp::execute(AstProject* const proj)
{
    Reporter* reporter = NULL;
    if (UserPreferences::get()->contextOutput) {
        reporter = new ContextReporter(cout);
    }
    else {
        reporter = new TerseReporter(cout);
    }
    reporter->setUnbuffered();
    
    DocumentationAnalyzer da(reporter);
    proj->getProcessed(&da);
    delete reporter;
}

ErrorRegistry* DocumentationAnalyzerApp::getErrorRegistry() const
{
    return DocErrorRegistry::get();
}
