#ifndef FieldDocumentationAnalyzer_h
#define FieldDocumentationAnalyzer_h

#ifndef ItemDocumentationAnalyzer_h
#include "ItemDocumentationAnalyzer.h"
#endif

namespace doctorj 
{
    class AstFieldDeclaration;
    class AstItem;
    class AstModifierList;
    class AstNoncode;
    class Reporter;
    class AstTaggedComment;
    class AstVariableDeclarator;

    class FieldDocumentationAnalyzer : public ItemDocumentationAnalyzer 
    {
    public:
        FieldDocumentationAnalyzer(Reporter* const reporter,
                                   AstFieldDeclaration* const fd,
                                   AstModifierList* const modifiers);

        /**
         * Not useful for checking code. Only for invoking methods associated
         * with the given documentation analyzer types, not the code itself.
         */
        FieldDocumentationAnalyzer();

        virtual ~FieldDocumentationAnalyzer();

        /**
         * Checks if the tagged comment is valid for a field.
         */
        virtual bool handleTag(AstTaggedComment* const tc);

        /**
         * Returns the noncode preceding the field declaration. This noncode
         * should contain the Javadoc comment, if any.
         */
        virtual AstNoncode* leadingNoncode();

        /**
         * What type of object we're analyzing, a "field".
         */
        virtual string type() const;

        /**
         * The identifier of what we're analyzing.
         */
        virtual AstItem* getSubject();

        /**
         * Checks the serial field tag.
         */
        virtual void checkSerialField(AstTaggedComment* const tc);

        /**
         * Checks the serial tag.
         */
        virtual void checkSerial(AstTaggedComment* const tc);

        /**
         * Complain that each of the variables declared is not documented.
         */
        virtual void complainUndocumented();

        /**
         * Complain that each of the variables declared is not commented.
         */
        virtual void complainUncommented();

        /**
         * Creates the error for the usage of an invalid tag with a field.
         */
        virtual ErrorInvalidJavadocTag* makeUnknownTagError(AstItem* const item, 
                                                            const string& tag) const;

    protected:

        /**
         * Complains that the given variable declarator is not documented or
         * commented (which is the value of <code>docCmt</code>.
         */
        virtual void complainVariable(AstVariableDeclarator* const vd, const string& docCmt);

    private:
        /**
         * The field declaration being analyzed.
         */
        AstFieldDeclaration* field_;

    };
}

#endif //! FieldDocumentationAnalyzer_h
