#ifndef JavadocCommentSpellCheck_h
#include "JavadocCommentSpellCheck.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef DocumentationErrors_h
#include "DocumentationErrors.h"
#endif

#ifndef Reporter_h
#include "Reporter.h"
#endif

using namespace doctorj;
using namespace std;

JavadocCommentSpellCheck* JavadocCommentSpellCheck::instance_ = NULL;

JavadocCommentSpellCheck* JavadocCommentSpellCheck::get(Reporter* const reporter)
{
    if (!instance_) {
        instance_ = new JavadocCommentSpellCheck(reporter);
    }
    return instance_;
}

JavadocCommentSpellCheck::JavadocCommentSpellCheck(Reporter* const reporter) : reporter_(reporter)
{
}

JavadocCommentSpellCheck::~JavadocCommentSpellCheck()
{
}

void JavadocCommentSpellCheck::checkComment(const string& desc, char* const descStart, File* const sourceFile)
{
    descStart_ = descStart;
    sourceFile_ = sourceFile;
    check(desc);
}
        
void JavadocCommentSpellCheck::wordMisspelled(const string& word,
                                              int position,
                                              const multimap<int, string>& nearMatches)
{
    char* wstart = descStart_ + position;
    char* wend   = wstart + word.length() - 1;
    
    vector<string> possibilities;
    for (int i = 0; i < 4; ++i) { // 4 == max edit distance
        multimap<int, string>::const_iterator it   = nearMatches.lower_bound(i);
        multimap<int, string>::const_iterator stop = nearMatches.upper_bound(i);
        if (it != stop) {
            while (it != stop) {
                possibilities.push_back(it->second);
                ++it;
            }
            break;
        }
    }

    AstStringLeaf asl(wstart, wend, sourceFile_);
    ErrorMisspelledWord err(reporter_, &asl, word, possibilities);
    err.process();
}
