#ifndef JavadocParser_h
#define JavadocParser_h

#ifndef std_vector
#define std_vector
#include <vector>
#endif

using namespace std;

namespace doctorj 
{
    struct TagCmt {
        char* start;
        char* end;
        char* descStart;
        char* descEnd;
    };

    class JavadocParser
    {
    public:
        JavadocParser(char* start, char* end);

        virtual ~JavadocParser();

        void parse();

        void getDescription(char** start, char** end) const;

        void getTagCmts(vector<TagCmt>* const tags) const;

    protected:

        char* rewind(char* const from);

        void addTagCmt(char* const start, char* const end,
                       char* const descStart, char* const descEnd);
             
    private:

        char* start_;

        char* end_;

        char* pos_;

        char* descStart_;

        char* descEnd_;

        vector<TagCmt> tags_;

    };
}

#endif //! JavadocParser_h
