#ifndef Test_h
#include "Test.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef Platform_h
#include "Platform.h"
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

#ifndef std_iterator
#define std_iterator
#include <iterator>
#endif

using namespace doctorj;

class JavaSourceLoaderTest : public Test 
{
public:
    JavaSourceLoaderTest(int argc, char** argv);
    virtual void run();
    virtual void process(const string& pkgName);
private:
    int argc_;
    char** argv_;
    JavaSourceLoader* loader_;
};


JavaSourceLoaderTest::JavaSourceLoaderTest(int argc, char** argv) : Test(true), argc_(argc), argv_(argv)
{
}

void JavaSourceLoaderTest::process(const string& pkgName)
{
    cout << "processing " << pkgName << endl;
    vector<string> types;
    loader_->getTypesInPackage(pkgName, &types);
    copy(types.begin(), types.end(), ostream_iterator<string>(cout, "\n"));
    cout << endl;
    cout << "-------------------------------------------------------" << endl;
}

void JavaSourceLoaderTest::run() 
{
    string cp;
    Platform::getEnv("SOURCEPATH", &cp);
    loader_ = JavaSourceLoader::get(NULL, cp);
    if (argc_ == 1) {
        process("java.lang");
    }
    else {
        for (int i = 1; i < argc_; ++i) {
            process(argv_[i]);
        }
    }
}

int main(int argc, char** argv) 
{
    JavaSourceLoaderTest t(argc, argv);
    t.run();
    cout << "source loader test results: " << t << endl;
    return t.nerrors();
}
