#ifndef DoctorJ_h
#include "DoctorJ.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

using namespace doctorj;

DoctorJ::DoctorJ() : 
        App("doctorj", "Java analysis suite"),
     checkDoc_(true),
     checkStats_(false),
     checkSyntax_(false),
     printAST_(false)
{
    buildOptions();
}

DoctorJ::~DoctorJ()
{
}

void DoctorJ::addOptions(yagol::AppOptionSet* const opts)
{
    docChecker_.addOptions(opts);
    opts->addOption("documentation",
                    "whether to check for documentation errors",
                    &checkDoc_);

    statsAnalyzer_.addOptions(opts);
    opts->addOption("statistics",
                    "display project statistics",
                    &checkStats_);

    // turning on statistics.xml implies that statistics are being generated:
    opts->addLink("statistics", "statistics.xml");

    // ditto for the summary.
    opts->addLink("statistics", "statistics.summary");

    syntaxAnalyzer_.addOptions(opts);
    opts->addOption("syntax",
                    "check syntax",
                    &checkSyntax_);
    
    astPrinter_.addOptions(opts);
    opts->addOption("ast",
                    "print the abstract syntax tree",
                    &printAST_);
    // turning on ast.xml implies that the AST is being displayed:
    opts->addLink("ast", "ast.xml");
}

void DoctorJ::execute(AstProject* const proj)
{
    if (checkDoc_) {
        docChecker_.execute(proj);
    }

    if (checkSyntax_) {
        syntaxAnalyzer_.execute(proj);
    }

    if (checkStats_) {
        statsAnalyzer_.execute(proj);
    }

    if (printAST_) {
        astPrinter_.execute(proj);
    }
}
