#ifndef CompilationUnitStatistics_h
#include "CompilationUnitStatistics.h"
#endif

using namespace doctorj;

CompilationUnitStatistics::CompilationUnitStatistics(const string& filename,
                                                     int nLines,
                                                     int nImports) : 
        Statistics(filename, nLines), nImports_(nImports)
{
}

CompilationUnitStatistics::~CompilationUnitStatistics()
{
    vector<InnerTypeStatistics*>::iterator it   = containedTypes_.begin();
    vector<InnerTypeStatistics*>::iterator stop = containedTypes_.end();
    while (it != stop) {
        InnerTypeStatistics* cts = *it;
        delete cts;
        ++it;
    }
}

int CompilationUnitStatistics::getImportCount() const
{
    return nImports_;
}

/* pointer to InnerTypeStatistics count method. ugh. */
typedef int (InnerTypeStatistics::*PCTSCM)() const;

static int sum(const CompilationUnitStatistics* const cus, PCTSCM fun) // and it _is_ fun!
{
    vector<InnerTypeStatistics*>::const_iterator it   = cus->types().begin();
    vector<InnerTypeStatistics*>::const_iterator stop = cus->types().end();
    int num = 0;
    while (it != stop) {
        InnerTypeStatistics* ts = *it;
        num += (ts->*fun)();
        ++it;
    }
    return num;
}

int CompilationUnitStatistics::getStaticMethodsCount() const
{
    // I should use accumulate here.
    return sum(this, &InnerTypeStatistics::getStaticMethodsCount);
}

int CompilationUnitStatistics::getInstanceMethodsCount() const
{
    return sum(this, &InnerTypeStatistics::getInstanceMethodsCount);
}

int CompilationUnitStatistics::getStaticFieldsCount() const
{
    return sum(this, &InnerTypeStatistics::getStaticFieldsCount);
}

int CompilationUnitStatistics::getInstanceFieldsCount() const
{
    return sum(this, &InnerTypeStatistics::getInstanceFieldsCount);
}

const vector<InnerTypeStatistics*>& CompilationUnitStatistics::types() const
{
    return containedTypes_;
}

void CompilationUnitStatistics::addType(InnerTypeStatistics* const cts)
{
    containedTypes_.push_back(cts);
}
