#ifndef ErrorAbstractMethodModifierUsedInInterface_h
#include "ErrorAbstractMethodModifierUsedInInterface.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif


using namespace doctorj;

REGISTER_DESCRIPTION(ErrorAbstractMethodModifierUsedInInterface);

ErrorAbstractMethodModifierUsedInInterface::ErrorAbstractMethodModifierUsedInInterface()
{
}

ErrorAbstractMethodModifierUsedInInterface::ErrorAbstractMethodModifierUsedInInterface(Reporter* const reporter, 
                                                                                       AstAbstractMethodDeclaration* const am,
                                                                                       AstInterfaceDeclaration* const id) :
        SyntaxError(reporter, am), 
     method_(am->getMethodHeader()->name()), 
     interface_(id->getIdentifier()->text())
{
}

ErrorAbstractMethodModifierUsedInInterface::~ErrorAbstractMethodModifierUsedInInterface()
{
}

string ErrorAbstractMethodModifierUsedInInterface::title() const
{
    return "Abstract Method Declared in Interface";
}

void ErrorAbstractMethodModifierUsedInInterface::writeDescription(ostream& os) const
{
    os << "All methods in an interface are abstract." << endl;
}

string ErrorAbstractMethodModifierUsedInInterface::message() const
{
    return "method '" + method_ + "' was declared abstract, in interface '" + interface_ + "'";
}
