#ifndef ErrorExcessiveMethodLength_h
#define ErrorExcessiveMethodLength_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj 
{
    class ErrorExcessiveMethodLength : public SyntaxError 
    {
    public:
        
        ErrorExcessiveMethodLength();

        /**
         * Creates the error for the method.
         */
        ErrorExcessiveMethodLength(Reporter* const reporter, AstItem* const item, const string& name, int length, int limit);

        virtual ~ErrorExcessiveMethodLength();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

    private:
        /**
         * The name of the method.
         */
        string name_;

        /**
         * The length of the method.
         */
        int length_;

        /**
         * The maximum length for methods.
         */
        int limit_;

    };

}

#endif //! ErrorExcessiveMethodLength_h
