#ifndef ErrorForWithoutBlock_h
#include "ErrorForWithoutBlock.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

using namespace doctorj;

REGISTER_DESCRIPTION(ErrorForWithoutBlock);

ErrorForWithoutBlock::ErrorForWithoutBlock()
{
}

ErrorForWithoutBlock::ErrorForWithoutBlock(Reporter* const reporter, 
                                           AstForStatement* const fs)
        : SyntaxError(reporter, fs)
{
}

ErrorForWithoutBlock::~ErrorForWithoutBlock()
{
}

string ErrorForWithoutBlock::title() const
{
    return "For Statement without Block";
}

void ErrorForWithoutBlock::writeDescription(ostream& os) const
{
    os << "for statements should use blocks." << endl;
}

string ErrorForWithoutBlock::message() const
{
    return "for statement without block";
}

