#ifndef ErrorForWithoutBlock_h
#define ErrorForWithoutBlock_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj
{
    class AstForStatement;

    class ErrorForWithoutBlock : public SyntaxError
    {
    public:
        ErrorForWithoutBlock();

        ErrorForWithoutBlock(Reporter* const reporter, AstForStatement* const fs);

        virtual ~ErrorForWithoutBlock();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;
    };

}

#endif //! ErrorForWithoutBlock_h
