#ifndef ErrorGenericCatch_h
#define ErrorGenericCatch_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj 
{
    class AstCatchClause;

    class ErrorGenericCatch : public SyntaxError 
    {
    public:
        
        ErrorGenericCatch();

        /**
         * Creates the error.
         */
        ErrorGenericCatch(Reporter* const reporter, AstCatchClause* const cc);

        virtual ~ErrorGenericCatch();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

    private:

        string type_;

    };

}

#endif //! ErrorGenericCatch_h
