#ifndef ErrorModifiersOutOfOrder_h
#define ErrorModifiersOutOfOrder_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj 
{
    class ErrorModifiersOutOfOrder : public SyntaxError 
    {
    public:
        
        ErrorModifiersOutOfOrder();

        /**
         * Creates the error.
         */
        ErrorModifiersOutOfOrder(Reporter* const reporter, AstItem* const item, AstItem* const current, AstItem* const previous);

        virtual ~ErrorModifiersOutOfOrder();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

    private:

        /**
         * The current modifier.
         */
        AstItem* current_;

        /**
         * The previous modifier.
         */
        AstItem* previous_;

    };

}

#endif //! ErrorModifiersOutOfOrder_h
