#ifndef ErrorObjectSubclassesCompared_h
#define ErrorObjectSubclassesCompared_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

#ifndef std_string
#define std_string
#include <string>
#endif

namespace doctorj
{
    class AstEqualityExpression;

    class ErrorObjectSubclassesCompared : public SyntaxError
    {
    public:
        ErrorObjectSubclassesCompared();

        ErrorObjectSubclassesCompared(Reporter* const reporter, 
                                      AstEqualityExpression* const ee,
                                      const string& type);
        
        virtual ~ErrorObjectSubclassesCompared();

        virtual string comp() const = 0;

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

    private:
        string type_;

    };


    class ErrorObjectSubclassesComparedWithEqEq : public ErrorObjectSubclassesCompared
    {
    public:
        ErrorObjectSubclassesComparedWithEqEq();

        ErrorObjectSubclassesComparedWithEqEq(Reporter* const reporter, 
                                              AstEqualityExpression* const ee,
                                              const string& type);

        virtual ~ErrorObjectSubclassesComparedWithEqEq();

        virtual string comp() const;

    };


    class ErrorObjectSubclassesComparedWithNotEq : public ErrorObjectSubclassesCompared
    {
    public:
        ErrorObjectSubclassesComparedWithNotEq();

        ErrorObjectSubclassesComparedWithNotEq(Reporter* const reporter, 
                                               AstEqualityExpression* const ee,
                                               const string& type);

        virtual ~ErrorObjectSubclassesComparedWithNotEq();

        virtual string comp() const;

    };

}

#endif //! ErrorObjectSubclassesCompared_h
