#ifndef ErrorPackageAccess_h
#define ErrorPackageAccess_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj 
{
    class AstItem;

    class ErrorPackageAccess : public SyntaxError 
    {
    public:
        ErrorPackageAccess();

        /**
         * Creates the error.
         */
        ErrorPackageAccess(Reporter* const reporter, AstItem* const item, const string& name);

        virtual ~ErrorPackageAccess();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

        /**
         * Returns what type of thing this refers to, in lowercase format.
         */
        virtual string typeAsLowercase() const = 0;

        /**
         * Returns what type of thing this refers to, in capitalized format.
         */
        virtual string typeAsCapitalized() const = 0;

    private:
        /**
         * The name.
         */
        string name_;
        
    };
}

#endif //! ErrorPackageAccess_h
