#ifndef FieldReferenceList_h
#include "FieldReferenceList.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

#ifndef iterext_h
#include "iterext.h"
#endif

#ifndef DeleteObject_h
#include "DeleteObject.h"
#endif

#ifndef std_algorithm
#define std_algorithm
#include <algorithm>
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

using namespace doctorj;
using namespace std;

FieldReferenceList::FieldReferenceList()
{
}

FieldReferenceList::~FieldReferenceList()
{
    clear();
}

bool FieldReferenceList::addReference(const string& fieldName)
{
    map<AstFieldDeclaration*, int>::iterator it = references_.begin();
    map<AstFieldDeclaration*, int>::iterator stop = references_.end();
    while (it != stop) {
        AstFieldDeclaration* fd = it->first;
        AstVariableDeclaratorList* vdl = fd->getVariableDeclaratorList();

        int count = vdl->getVariableDeclaratorCount();
        for (int i = 0; i < count; ++i) {
            AstVariableDeclarator* vd = vdl->getVariableDeclarator(i);
            AstVariableDeclaratorId* vdid = vd->getVariableDeclaratorId();
            AstIdentifier* id = vdid->getIdentifier();
            string name = id->text();
            cout << "FLDREFLS considering " << name << endl;
        }

        ++it;
    }
    return false;
}

void FieldReferenceList::addDeclaration(AstFieldDeclaration* const fd)
{
    references_[fd] = 0;
}

void FieldReferenceList::clear()
{
    references_.clear();
}

vector<AstFieldDeclaration*> FieldReferenceList::getUnreferencedFields() const
{
    vector<AstFieldDeclaration*> unused;
    
//     EACHC(vector<ReferencedField*>, references_, it) {
//         ReferencedField* ref = *it;
//         if (ref->isUnused()) {
//             unused.push_back(ref->declaration());
//         }
//     }

    return unused;
}
