#ifndef ImportList_h
#include "ImportList.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

#ifndef ReferencedImport_h
#include "ReferencedImport.h"
#endif

#ifndef iterext_h
#include "iterext.h"
#endif

#ifndef DeleteObject_h
#include "DeleteObject.h"
#endif

#ifndef std_algorithm
#define std_algorithm
#include <algorithm>
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

using namespace doctorj;
using namespace std;

ImportList::ImportList()
{
}

ImportList::~ImportList()
{
    clear();
}

ReferencedImport* ImportList::findExplicitMatch(const string& typeName) const
{
    SYNLOGF("ImportList::findExplicitMatch(%s)", typeName.c_str());
    EACHC(vector<ReferencedImport*>, imports_, it) {
        ReferencedImport* ref = *it;
        if (ReferencedSingleImport* rsi = dynamic_cast<ReferencedSingleImport*>(ref)) {
            if (rsi->isMatch(typeName)) {
                return rsi;
            }
        }
    }
    return NULL;
}
        
ReferencedImport* ImportList::findImplicitMatch(const string& typeName) const
{
    SYNLOGF("ImportList::findImplicitMatch(%s)", typeName.c_str());
    EACHC(vector<ReferencedImport*>, imports_, it) {
        ReferencedImport* ref = *it;
        if (ReferencedOnDemandImport* rodi = dynamic_cast<ReferencedOnDemandImport*>(ref)) {
            if (rodi->isMatch(typeName)) {
                return rodi;
            }
        }
    }
    return NULL;
}

ReferencedImport* ImportList::findByFullName(const string& fullName) const
{
    vector<ReferencedImport*>::const_iterator it   = imports_.begin();
    vector<ReferencedImport*>::const_iterator stop = imports_.end();
    while (it != stop) {
        ReferencedImport* imp = *it;
        if (imp->fullName() == fullName) {
            return imp;
        }
        ++it;
    }

    // cout << "ImportList::findByFullName(" << fullName << "): not found" << endl;
    return NULL;
}
        
ReferencedImport* ImportList::findBestMatch(const string& typeName) const
{
    vector<ReferencedImport*>::const_iterator it   = imports_.begin();
    vector<ReferencedImport*>::const_iterator stop = imports_.end();
    while (it != stop) {
        ReferencedImport* imp = *it;
        if (imp->isExactMatch(typeName)) {
            return imp;
        }
        ++it;
    }

    it   = imports_.begin();
    stop = imports_.end();
    while (it != stop) {
        ReferencedImport* imp = *it;
        if (imp->isMatch(typeName)) {
            return imp;
        }
        ++it;
    }

    // cout << "ImportList::findBestMatch(" << typeName << "): not found" << endl;
    return NULL;
}

void ImportList::add(AstImportDeclarationSingle* const id)
{
    imports_.push_back(new ReferencedSingleImport(id));
}

void ImportList::add(AstImportDeclarationOnDemand* const id)
{
    imports_.push_back(new ReferencedOnDemandImport(id));
}

void ImportList::clear()
{
    for_each(imports_.begin(), imports_.end(), DeleteObject());
    imports_.clear();
}

vector<AstImportDeclaration*> ImportList::getUnusedImports() const
{
    vector<AstImportDeclaration*> unused;

    EACHC(vector<ReferencedImport*>, imports_, it) {
        ReferencedImport* ref = *it;
        if (ref->isUnused()) {
            unused.push_back(ref->declaration());
        }
    }

    return unused;
}

void ImportList::checkForMatch(const string& typeName) const
{
    SYNLOGF("typeName: '%s'", typeName.c_str());
    
    ReferencedImport* ri = findExplicitMatch(typeName);
    if (!ri) {
        ri = findImplicitMatch(typeName);
    }
    
    if (ri) {
        ri->addReference();
    }
}

