#ifndef RuleAbstractMethodModifierUsedInInterface_h
#include "RuleAbstractMethodModifierUsedInInterface.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef ErrorAbstractMethodModifierUsedInInterface_h
#include "ErrorAbstractMethodModifierUsedInInterface.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

using namespace std;
using namespace doctorj;

RuleAbstractMethodModifierUsedInInterface::RuleAbstractMethodModifierUsedInInterface(Reporter* const reporter) : Rule(reporter)
{
}

RuleAbstractMethodModifierUsedInInterface::~RuleAbstractMethodModifierUsedInInterface()
{
}

void RuleAbstractMethodModifierUsedInInterface::process(AstAbstractMethodDeclaration* const am)
{
    SYNLOG("");
    AstMethodHeader*     methHdr = am->getMethodHeader();
    AstMethodDeclarator* methDec = methHdr->getMethodDeclarator();
    AstItem*             methNm  = methDec->getIdentifier();
    
    // in an interface, "abstract" is unnecessary
    AstItem* it = am->parent(); 
    while (it) {
        // are we in an interface?
        if (AstInterfaceDeclaration* idec = dynamic_cast<AstInterfaceDeclaration*>(it)) {
            // yes, we're in an interface... so was this method qualified as "abstract"?
            JavaMethod jm(methHdr);
            if (jm.isAbstract()) {
                ErrorAbstractMethodModifierUsedInInterface* err = new ErrorAbstractMethodModifierUsedInInterface(reporter(), am, idec);
                err->process();
                break;
            }
        }
        
        it = it->parent();
    }
    traverse(am);
}
