#ifndef RuleEmptyForStatement_h
#include "RuleEmptyForStatement.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef ErrorEmptyForStatement_h
#include "ErrorEmptyForStatement.h"
#endif

#ifndef Log_h
#include "Log.h"
#endif

using namespace std;
using namespace doctorj;

RuleEmptyForStatement::RuleEmptyForStatement(Reporter* const reporter) : Rule(reporter)
{
}

RuleEmptyForStatement::~RuleEmptyForStatement()
{
}

void RuleEmptyForStatement::process(AstForStatement* const fs)
{
    LOG(5, "RuleEmptyForStatement.process");
    // check statement for ';' without any preceding comment
    AstItem* statement = fs->getStatement();
    if (JavaItem::isEmptyStatement(statement)) {
        LOG(5, "statement is empty");
        ErrorEmptyForStatement* err = new ErrorEmptyForStatement(reporter(), fs);
        LOG(5, "created error; processing it");
        err->process();
    }
    else {
        LOG(5, "statement is NOT empty");
    }
    traverse(fs);
}

void RuleEmptyForStatement::process(AstForStatementNoInitConditionNoUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleEmptyForStatement::process(AstForStatementNoInitConditionUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleEmptyForStatement::process(AstForStatementNoInitNoConditionNoUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleEmptyForStatement::process(AstForStatementNoInitNoConditionUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleEmptyForStatement::process(AstForStatementStmtsConditionNoUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleEmptyForStatement::process(AstForStatementStmtsConditionUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleEmptyForStatement::process(AstForStatementStmtsNoConditionNoUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleEmptyForStatement::process(AstForStatementStmtsNoConditionUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleEmptyForStatement::process(AstForStatementVarsConditionNoUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleEmptyForStatement::process(AstForStatementVarsConditionUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleEmptyForStatement::process(AstForStatementVarsNoConditionNoUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleEmptyForStatement::process(AstForStatementVarsNoConditionUpdate* const fs)
{
    process((AstForStatement*)fs);
}
