#ifndef RuleEmptyWhileStatement_h
#include "RuleEmptyWhileStatement.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef ErrorEmptyWhileStatement_h
#include "ErrorEmptyWhileStatement.h"
#endif

using namespace std;
using namespace doctorj;

RuleEmptyWhileStatement::RuleEmptyWhileStatement(Reporter* const reporter) : Rule(reporter)
{
}

RuleEmptyWhileStatement::~RuleEmptyWhileStatement()
{
}

void RuleEmptyWhileStatement::process(AstWhileStatement* const ws)
{
    if (JavaItem::isEmptyStatement(ws->getStatement())) {
        (new ErrorEmptyWhileStatement(reporter(), ws))->process();
    }
    traverse(ws);
}
