#ifndef RuleExcessiveMethodLength_h
#include "RuleExcessiveMethodLength.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef UserPreferences_h
#include "UserPreferences.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef ErrorExcessiveMethodLength_h
#include "ErrorExcessiveMethodLength.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

using namespace std;
using namespace doctorj;

int RuleExcessiveMethodLength::maxLength = -2;

RuleExcessiveMethodLength::RuleExcessiveMethodLength(Reporter* const reporter) : Rule(reporter)
{
    SYNLOG("");
    
    SYNLOGF("maxLength: %d", maxLength);
    
    if (maxLength == -2) {
        UserPreferences* prefs = UserPreferences::get();
        maxLength = prefs->maxMethodLength;
        SYNLOGF("set max length to %d", maxLength);
    }
}

RuleExcessiveMethodLength::~RuleExcessiveMethodLength()
{
}

void RuleExcessiveMethodLength::process(AstMethodDeclarationBlock* const md)
{
    SYNLOG("");
    
    int length = md->endLine() - md->line();
    SYNLOGF("length: %d", length);
    
    if (length > maxLength) {
        (new ErrorExcessiveMethodLength(reporter(), md->getMethodHeader(), md->getMethodHeader()->name(), length, maxLength))->process();
    }
    traverse(md);
}
