#ifndef RuleForWithoutBlock_h
#include "RuleForWithoutBlock.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef ErrorForWithoutBlock_h
#include "ErrorForWithoutBlock.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

using namespace std;
using namespace doctorj;

RuleForWithoutBlock::RuleForWithoutBlock(Reporter* const reporter) : Rule(reporter)
{
}

RuleForWithoutBlock::~RuleForWithoutBlock()
{
}

void RuleForWithoutBlock::process(AstForStatement* const fs)
{
    // check statement for ';' without any preceding comment
    AstItem* statement = fs->getStatement();
    if (!JavaItem::isEmptyStatement(statement) && !dynamic_cast<AstBlock*>(statement)) {
        SYNLOG("SYNTANAL  warning: statement is not a block");
        ErrorForWithoutBlock* err = new ErrorForWithoutBlock(reporter(), fs);
        err->process();
    }

    traverse(fs);
}

void RuleForWithoutBlock::process(AstForStatementNoInitConditionNoUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleForWithoutBlock::process(AstForStatementNoInitConditionUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleForWithoutBlock::process(AstForStatementNoInitNoConditionNoUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleForWithoutBlock::process(AstForStatementNoInitNoConditionUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleForWithoutBlock::process(AstForStatementStmtsConditionNoUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleForWithoutBlock::process(AstForStatementStmtsConditionUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleForWithoutBlock::process(AstForStatementStmtsNoConditionNoUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleForWithoutBlock::process(AstForStatementStmtsNoConditionUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleForWithoutBlock::process(AstForStatementVarsConditionNoUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleForWithoutBlock::process(AstForStatementVarsConditionUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleForWithoutBlock::process(AstForStatementVarsNoConditionNoUpdate* const fs)
{
    process((AstForStatement*)fs);
}

void RuleForWithoutBlock::process(AstForStatementVarsNoConditionUpdate* const fs)
{
    process((AstForStatement*)fs);
}
