#ifndef RuleMethodPackageAccess_h
#include "RuleMethodPackageAccess.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef ErrorMethodPackageAccess_h
#include "ErrorMethodPackageAccess.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

using namespace std;
using namespace doctorj;

RuleMethodPackageAccess::RuleMethodPackageAccess(Reporter* const reporter) : Rule(reporter)
{
}

RuleMethodPackageAccess::~RuleMethodPackageAccess()
{
}

void RuleMethodPackageAccess::process(AstMethodHeader* const mh)
{
    SYNLOG("");

    if (JavaModifierList::getAccess(mh->getModifierList()) == NULL) {
        ErrorMethodPackageAccess* err = new ErrorMethodPackageAccess(reporter(), mh);
        err->process();
    }

    traverse(mh);
}

void RuleMethodPackageAccess::process(AstMethodHeaderTypeModsNoThrows* const mh)
{
    process((AstMethodHeader*)mh);
}

void RuleMethodPackageAccess::process(AstMethodHeaderTypeModsThrows* const mh)
{
    process((AstMethodHeader*)mh);
}

void RuleMethodPackageAccess::process(AstMethodHeaderTypeNoModsNoThrows* const mh)
{
    process((AstMethodHeader*)mh);
}

void RuleMethodPackageAccess::process(AstMethodHeaderTypeNoModsThrows* const mh)
{
    process((AstMethodHeader*)mh);
}

void RuleMethodPackageAccess::process(AstMethodHeaderVoidModsNoThrows* const mh)
{
    process((AstMethodHeader*)mh);
}

void RuleMethodPackageAccess::process(AstMethodHeaderVoidModsThrows* const mh)
{
    process((AstMethodHeader*)mh);
}

void RuleMethodPackageAccess::process(AstMethodHeaderVoidNoModsNoThrows* const mh)
{
    process((AstMethodHeader*)mh);
}

void RuleMethodPackageAccess::process(AstMethodHeaderVoidNoModsThrows* const mh)
{
    process((AstMethodHeader*)mh);
}
