#ifndef RuleNoBreakInCaseStatement_h
#include "RuleNoBreakInCaseStatement.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef ErrorNoBreakInCaseStatement_h
#include "ErrorNoBreakInCaseStatement.h"
#endif

#ifndef RegExp_h
#include "RegExp.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

using namespace std;
using namespace doctorj;

RuleNoBreakInCaseStatement::RuleNoBreakInCaseStatement(Reporter* const reporter) : Rule(reporter)
{
}

RuleNoBreakInCaseStatement::~RuleNoBreakInCaseStatement()
{
}

void RuleNoBreakInCaseStatement::process(AstSwitchBlockStatementGroup* const sb)
{
    SYNLOG("");

    // check that the last statement is "break", or commented as
    // "fall(through|thru)"

    AstBlockStatementList* block = sb->getBlockStatementList();
    int count = block->getBlockStatementCount();
    if (count > 0) {
        AstItem* lastStatement = block->getBlockStatement(count - 1);
        AstBreakStatement* bs = dynamic_cast<AstBreakStatement*>(lastStatement);
        if (bs) {
            // break is good.
        }
        else if (dynamic_cast<AstReturnStatement*>(lastStatement)) {
            // also legal are return statements and System.exit()
            // return statements are OK
        }
        else {
            AstExpressionStatement*      es = dynamic_cast<AstExpressionStatement*>(lastStatement);
            AstMethodInvocationNameArgs* mi = es ? dynamic_cast<AstMethodInvocationNameArgs*>(es->getExpression()) : NULL;
            
            if (mi && mi->getName()->text() == "System.exit") {
                // that's acceptable
            }
            else if (AstNoncode* nc = JavaItem::getTrailingNoncode(lastStatement)) {
                RegExp ft(".*fall *(through|thru)");
                if (!ft.match(nc->text())) {
                    ErrorNoBreakInCaseStatement* err = new ErrorNoBreakInCaseStatement(reporter(), sb);
                    err->process();
                }
            }
            else {
                // still no noncode -- this is hard to believe
                ErrorNoBreakInCaseStatement* err = new ErrorNoBreakInCaseStatement(reporter(), sb);
                err->process();
            }
        }
    }

    traverse(sb);
}

