#ifndef RuleUnnecessaryImport_h
#include "RuleUnnecessaryImport.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef ErrorUnnecessaryImport_h
#include "ErrorUnnecessaryImport.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

#ifndef StringUtilities_h
#include "StringUtilities.h"
#endif

using namespace std;
using namespace doctorj;

RuleUnnecessaryImport::RuleUnnecessaryImport(Reporter* const reporter) : Rule(reporter)
{
}

RuleUnnecessaryImport::~RuleUnnecessaryImport()
{
}

void RuleUnnecessaryImport::process(AstImportDeclarationOnDemand* const id)
{
    SYNLOG("");

    // no need to import java.lang.*
    if (id->getName()->fullName() == "java.lang") {
        ErrorUnnecessaryImport* err = new ErrorUnnecessaryImport(reporter(), id);
        err->process();
    }
}

void RuleUnnecessaryImport::process(AstImportDeclarationSingle* const id)
{
    // no need to import java.lang.Foo
    vector<string> pieces = StringUtilities::split(id->getName()->fullName(), ".");
    if (pieces.size() == 3 && pieces[0] == "java" && pieces[1] == "lang") {
        ErrorUnnecessaryImport* err = new ErrorUnnecessaryImport(reporter(), id);
        err->process();
    }
}
