#ifndef RuleUselessSuperInMethodInvocation_h
#include "RuleUselessSuperInMethodInvocation.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef ErrorUselessSuperInMethodInvocation_h
#include "ErrorUselessSuperInMethodInvocation.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

using namespace std;
using namespace doctorj;

RuleUselessSuperInMethodInvocation::RuleUselessSuperInMethodInvocation(Reporter* const reporter) : Rule(reporter)
{
}

RuleUselessSuperInMethodInvocation::~RuleUselessSuperInMethodInvocation()
{
}

void RuleUselessSuperInMethodInvocation::process(AstMethodInvocationSuper* const mi, const JavaArgumentTypeList& argTypes)
{
    SYNLOG("");

    string target = mi->getIdentifier()->text();
    JavaType* type = JavaItem::getContainingType(mi);
    if (type && !type->hasLocalMethod(target, argTypes)) {
        ErrorUselessSuperInMethodInvocation* err = new ErrorUselessSuperInMethodInvocation(reporter(), mi);
        err->process();
    }
}

void RuleUselessSuperInMethodInvocation::process(AstMethodInvocationSuperArgs* const mi)
{
    process((AstMethodInvocationSuper*)mi, JavaGrammar::getArgumentTypes(mi));
}

void RuleUselessSuperInMethodInvocation::process(AstMethodInvocationSuperNoArgs* const mi)
{
    process((AstMethodInvocationSuper*)mi, JavaGrammar::getArgumentTypes(mi));
}
