#ifndef SyntaxAnalyzer_h
#include "SyntaxAnalyzer.h"
#endif

#ifndef UserPreferences_h
#include "UserPreferences.h"
#endif

#ifndef ContextReporter_h
#include "ContextReporter.h"
#endif

#ifndef TerseReporter_h
#include "TerseReporter.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

#ifndef RuleAbstractMethodModifierUsedInInterface_h
#include "RuleAbstractMethodModifierUsedInInterface.h"
#endif

#ifndef RuleAbstractModifierUsedForInterface_h
#include "RuleAbstractModifierUsedForInterface.h"
#endif

#ifndef RuleEmptyFor_h
#include "RuleEmptyFor.h"
#endif

#ifndef RuleEmptyForStatement_h
#include "RuleEmptyForStatement.h"
#endif

#ifndef RuleEmptyIfStatement_h
#include "RuleEmptyIfStatement.h"
#endif

#ifndef RuleEmptyWhileStatement_h
#include "RuleEmptyWhileStatement.h"
#endif

#ifndef RuleExcessiveMethodLength_h
#include "RuleExcessiveMethodLength.h"
#endif

#ifndef RuleExplicitFalseInConditional_h
#include "RuleExplicitFalseInConditional.h"
#endif

#ifndef RuleExplicitSuperCall_h
#include "RuleExplicitSuperCall.h"
#endif

#ifndef RuleExplicitTrueInConditional_h
#include "RuleExplicitTrueInConditional.h"
#endif

#ifndef RuleFieldPackageAccess_h
#include "RuleFieldPackageAccess.h"
#endif

#ifndef RuleForWithoutBlock_h
#include "RuleForWithoutBlock.h"
#endif

#ifndef RuleGenericCatch_h
#include "RuleGenericCatch.h"
#endif

#ifndef RuleGenericExceptionSpecification_h
#include "RuleGenericExceptionSpecification.h"
#endif

#ifndef RuleIfStatementsReversed_h
#include "RuleIfStatementsReversed.h"
#endif

#ifndef RuleImproperSequence_h
#include "RuleImproperSequence.h"
#endif

#ifndef RuleMethodPackageAccess_h
#include "RuleMethodPackageAccess.h"
#endif

#ifndef RuleModifiersOutOfOrder_h
#include "RuleModifiersOutOfOrder.h"
#endif

#ifndef RuleNoBreakInCaseStatement_h
#include "RuleNoBreakInCaseStatement.h"
#endif

#ifndef RuleNoDefaultCase_h
#include "RuleNoDefaultCase.h"
#endif

#ifndef RuleObjectSubclassesCompared_h
#include "RuleObjectSubclassesCompared.h"
#endif

#ifndef RulePublicField_h
#include "RulePublicField.h"
#endif

#ifndef RuleRepeatedImportStatement_h
#include "RuleRepeatedImportStatement.h"
#endif

#ifndef RuleReturnFromVoidMethod_h
#include "RuleReturnFromVoidMethod.h"
#endif

#ifndef RuleUninitializedStaticField_h
#include "RuleUninitializedStaticField.h"
#endif

#ifndef RuleUnnecessaryImport_h
#include "RuleUnnecessaryImport.h"
#endif

#ifndef RuleUnreferencedImport_h
#include "RuleUnreferencedImport.h"
#endif

#ifndef RuleUselessSuperInMethodInvocation_h
#include "RuleUselessSuperInMethodInvocation.h"
#endif

#ifndef RuleUselessThisInMethodInvocation_h
#include "RuleUselessThisInMethodInvocation.h"
#endif

#ifndef Log_h
#include "Log.h"
#endif

using namespace std;
using namespace doctorj;

SyntaxAnalyzer::SyntaxAnalyzer(Reporter* const reporter) : ProcessorSet(reporter)
{
    addRule(new RuleAbstractMethodModifierUsedInInterface(reporter));
    addRule(new RuleAbstractModifierUsedForInterface(reporter));
    addRule(new RuleEmptyFor(reporter));
    addRule(new RuleEmptyForStatement(reporter));
    addRule(new RuleEmptyIfStatement(reporter));
    addRule(new RuleEmptyWhileStatement(reporter));
    addRule(new RuleExcessiveMethodLength(reporter));
    addRule(new RuleExplicitFalseInConditional(reporter));
    addRule(new RuleExplicitSuperCall(reporter));
    addRule(new RuleExplicitTrueInConditional(reporter));
    addRule(new RuleFieldPackageAccess(reporter));
    addRule(new RuleForWithoutBlock(reporter));
    addRule(new RuleGenericCatch(reporter));
    addRule(new RuleGenericExceptionSpecification(reporter));
    addRule(new RuleIfStatementsReversed(reporter));
    addRule(new RuleImproperSequence(reporter));
    addRule(new RuleMethodPackageAccess(reporter));
    addRule(new RuleModifiersOutOfOrder(reporter));
    addRule(new RuleNoBreakInCaseStatement(reporter));
    addRule(new RuleNoDefaultCase(reporter));
    addRule(new RuleObjectSubclassesCompared(reporter));
    addRule(new RulePublicField(reporter));
    addRule(new RuleRepeatedImportStatement(reporter));
    addRule(new RuleReturnFromVoidMethod(reporter));
    addRule(new RuleUninitializedStaticField(reporter));
    addRule(new RuleUnnecessaryImport(reporter));
    addRule(new RuleUnreferencedImport(reporter));
    addRule(new RuleUselessSuperInMethodInvocation(reporter));
    addRule(new RuleUselessThisInMethodInvocation(reporter));
}

SyntaxAnalyzer::~SyntaxAnalyzer()
{
}


REGISTER_DEBUG_OPTION('s', "Syntax analyzer");
static doctorj::DebugOptionRegistrant java_debug_option('j', "Java code (decompiling and encapsulation)");

static void addNameFormats(yagol::AppOptionSet* const opts)
{
    UserPreferences* prefs = UserPreferences::get();
    struct NameOpt {
        char* type;
        char* fnfl;
        char* access;
        string* value;
    } formats[] = { 
        { "instance", "final",    "public",    &(prefs->formatInstanceFinalPublic) },
        { "instance", "final",    "protected", &(prefs->formatInstanceFinalProtected) },
        { "instance", "final",    "package",   &(prefs->formatInstanceFinalPackage) },
        { "instance", "final",    "private",   &(prefs->formatInstanceFinalPrivate) },
        { "instance", "nonfinal", "public",    &(prefs->formatInstanceNonfinalPublic) },
        { "instance", "nonfinal", "protected", &(prefs->formatInstanceNonfinalProtected) },
        { "instance", "nonfinal", "package",   &(prefs->formatInstanceNonfinalPackage) },
        { "instance", "nonfinal", "private",   &(prefs->formatInstanceNonfinalPrivate) },
        { "static",   "final",    "public",    &(prefs->formatStaticFinalPublic) },
        { "static",   "final",    "protected", &(prefs->formatStaticFinalProtected) },
        { "static",   "final",    "package",   &(prefs->formatStaticFinalPackage) },
        { "static",   "final",    "private",   &(prefs->formatStaticFinalPrivate) },
        { "static",   "nonfinal", "public",    &(prefs->formatStaticNonfinalPublic) },
        { "static",   "nonfinal", "protected", &(prefs->formatStaticNonfinalProtected) },
        { "static",   "nonfinal", "package",   &(prefs->formatStaticNonfinalPackage) },
        { "static",   "nonfinal", "private",   &(prefs->formatStaticNonfinalPrivate) }
    };
    
    int nFmts = sizeof(formats) / sizeof(formats[0]);
    for (int i = 0; i < nFmts; ++i) {
        string name = string("format.") + formats[i].type + "." + formats[i].fnfl + "." + formats[i].access;
        string desc = string("format of ") + formats[i].type + " " + 
            formats[i].fnfl + " " + formats[i].access + " variables";
        yagol::Option* opt = opts->addOption(name, desc, formats[i].value);
        opt->setConfigOnly(true);
    }
}

SyntaxAnalyzerApp::SyntaxAnalyzerApp() : App("syntj", "Java syntax analyzer")
{
    buildOptions();
}

SyntaxAnalyzerApp::~SyntaxAnalyzerApp()
{
}

void SyntaxAnalyzerApp::addOptions(yagol::AppOptionSet* const opts)
{
    addContextOption();
    addNameFormats(opts);

    UserPreferences* prefs = UserPreferences::get();
    
    yagol::Option* cp = opts->addOption("classpath",
                                        "The path for class files",
                                        &(prefs->classPath));

    yagol::Option* sp = opts->addOption("sourcepath", 
                                        "The path for source files, beyond those being explicitly checked", 
                                        &(prefs->sourcePath));

    yagol::Option* to = opts->addOption("types.order",
                                        "The order within type declarations",
                                        &(prefs->typeOrder));
    to->setConfigOnly(true);

    yagol::Option* ml = opts->addOption("method.length.max",
                                        "The maximum length of methods",
                                        &(prefs->maxMethodLength));
    ml->setConfigOnly(true);
}

void SyntaxAnalyzerApp::execute(AstProject* const proj)
{
    Reporter* reporter = NULL;
    if (UserPreferences::get()->contextOutput) {
        reporter = new ContextReporter(cout);
    }
    else {
        reporter = new TerseReporter(cout);
    }

    SyntaxAnalyzer sa(reporter);
    proj->getProcessed(&sa);
    delete reporter;
}
