#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleForWithoutBlock_h
#include "RuleForWithoutBlock.h"
#endif

#ifndef ErrorForWithoutBlock_h
#include "ErrorForWithoutBlock.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleForWithoutBlock";

class RuleForWithoutBlockTest : 
    public RuleTest<ruleName, RuleForWithoutBlock, ErrorForWithoutBlock>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        std::vector<std::string> vec0;
        vec0.push_back("class RuleForWithoutBlock {");
        vec0.push_back("    void foo() {");
        vec0.push_back("        for (int i = 0; i < 10; ++i)"); 
        vec0.push_back("            i = i * 2;");
        vec0.push_back("    }");
        vec0.push_back("}");
        contents->push_back(vec0);
                
        std::vector<std::string> vec1;
        vec1.push_back("class RuleForWithoutBlock {");
        vec1.push_back("    RuleForWithoutBlock() {");
        vec0.push_back("        for (int i = 0; i < 10; ++i)"); 
        vec0.push_back("            ;");
        vec1.push_back("    }");
        vec1.push_back("}");
        contents->push_back(vec1);
    }

    virtual int errorsExpected(int num) const { 
        return num == 0 ? 1 : 0; 
    }

};

int main(int argc, char** argv) 
{
    RuleForWithoutBlockTest t;
    t.run();
    cout << "for without block rule test results: " << t << endl;
    return t.nerrors();
}
