#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleIfStatementsReversed_h
#include "RuleIfStatementsReversed.h"
#endif

#ifndef ErrorIfStatementsReversed_h
#include "ErrorIfStatementsReversed.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleIfStatementsReversed";

class RuleIfStatementsReversedTest : 
    public RuleTest<ruleName, RuleIfStatementsReversed, ErrorIfStatementsReversed>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        {
            std::vector<std::string> vec0;
            vec0.push_back("class RuleIfStatementsReversed {");
            vec0.push_back("    RuleIfStatementsReversed(int i, int j) {");
            vec0.push_back("        if (i != j) {"); 
            vec0.push_back("        }"); 
            vec0.push_back("        else {"); 
            vec0.push_back("        }"); 
            vec0.push_back("    }");
            vec0.push_back("}");
            contents->push_back(vec0);
        }
         
        {
            std::vector<std::string> vec1;
            vec1.push_back("class RuleIfStatementsReversed {");
            vec1.push_back("    RuleIfStatementsReversed(boolean b) {");
            vec1.push_back("        if (!b) {"); 
            vec1.push_back("        }"); 
            vec1.push_back("        else {"); 
            vec1.push_back("        }"); 
            vec1.push_back("    }");
            vec1.push_back("}");
            contents->push_back(vec1);
        }

        {
            std::vector<std::string> vec0;
            vec0.push_back("class RuleIfStatementsReversed {");
            vec0.push_back("    RuleIfStatementsReversed(int i, int j) {");
            vec0.push_back("        if (i != j) {"); 
            vec0.push_back("        }"); 
            vec0.push_back("        else {"); 
            vec0.push_back("        }"); 
            vec0.push_back("    }");
            vec0.push_back("}");
            contents->push_back(vec0);
        }
         
        {
            std::vector<std::string> vec1;
            vec1.push_back("class RuleIfStatementsReversed {");
            vec1.push_back("    RuleIfStatementsReversed(boolean b) {");
            vec1.push_back("        if (!b) {"); 
            vec1.push_back("        }"); 
            vec1.push_back("        else {"); 
            vec1.push_back("        }"); 
            vec1.push_back("    }");
            vec1.push_back("}");
            contents->push_back(vec1);
        }
    }

    virtual int errorsExpected(int num) const { 
        return num < 4 ? 1 : 0; 
    }

};

int main(int argc, char** argv) 
{
    RuleIfStatementsReversedTest t;
    t.run();
    cout << "if statements reversed rule test results: " << t << endl;
    return t.nerrors();
}
