#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleModifiersOutOfOrder_h
#include "RuleModifiersOutOfOrder.h"
#endif

#ifndef ErrorModifiersOutOfOrder_h
#include "ErrorModifiersOutOfOrder.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleModifiersOutOfOrder";

class RuleModifiersOutOfOrderTest : 
    public RuleTest<ruleName, RuleModifiersOutOfOrder, ErrorModifiersOutOfOrder>
{
public:
    /**
     * the preferred order (IAW JPL3:38):
     *
     *     access
     *     static
     *     final
     *     transient
     *     volatile
     */
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleModifiersOutOfOrder {");
            vec.push_back("    static public void f() {");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleModifiersOutOfOrder {");
            vec.push_back("    static final public void f() {");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        } 

        {
            std::vector<std::string> vec;
            vec.push_back("class RuleModifiersOutOfOrder {");
            vec.push_back("    final static public void f() {");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        } 

        {
            std::vector<std::string> vec;
            vec.push_back("class RuleModifiersOutOfOrder {");
            vec.push_back("    transient public void f() {");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        } 
               
    }

    virtual int errorsExpected(int num) const { 
        switch (num) {
            case 0:
                return 1;
                break;

            case 1:
                return 1;
                break;

            case 2:
                return 2;
                break;

            case 3:
                return 1;
                break;

            default:
                return 0;
        }
    }

};

int main(int argc, char** argv) 
{
    RuleModifiersOutOfOrderTest t;
    t.run();
    cout << "modifiers out of order rule test results: " << t << endl;
    return t.nerrors();
}
