#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleReturnFromVoidMethod_h
#include "RuleReturnFromVoidMethod.h"
#endif

#ifndef ErrorReturnFromVoidMethod_h
#include "ErrorReturnFromVoidMethod.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleReturnFromVoidMethod";

class RuleReturnFromVoidMethodTest : 
    public RuleTest<ruleName, RuleReturnFromVoidMethod, ErrorReturnFromVoidMethod>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleReturnFromVoidMethod {");
            vec.push_back("    void f() {");
            vec.push_back("        return;"); 
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleReturnFromVoidMethod {");
            vec.push_back("    int f() {");
            vec.push_back("        return 3;"); 
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
    }

    virtual int errorsExpected(int num) const { 
        return num < 1 ? 1 : 0; 
    }

};

int main(int argc, char** argv) 
{
    RuleReturnFromVoidMethodTest t;
    t.run();
    cout << "return from void method rule test results: " << t << endl;
    return t.nerrors();
}
