#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleUselessSuperInMethodInvocation_h
#include "RuleUselessSuperInMethodInvocation.h"
#endif

#ifndef ErrorUselessSuperInMethodInvocation_h
#include "ErrorUselessSuperInMethodInvocation.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleUselessSuperInMethodInvocation";

class RuleUselessSuperInMethodInvocationTest : 
    public RuleTest<ruleName, RuleUselessSuperInMethodInvocation, ErrorUselessSuperInMethodInvocation>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleUselessSuperInMethodInvocation {");
            vec.push_back("    void bar() {");
            vec.push_back("        super.foo();");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleUselessSuperInMethodInvocation {");
            vec.push_back("    void foo() {");
            vec.push_back("    }");
            vec.push_back("");
            vec.push_back("    void bar() {");
            vec.push_back("        super.foo();");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
    }

    virtual int errorsExpected(int num) const { 
        return num < 1 ? 1 : 0; 
    }

};

int main(int argc, char** argv) 
{
    RuleUselessSuperInMethodInvocationTest t;
    t.run();
    cout << "useless super in method invocation rule test results: " << t << endl;
    return t.nerrors();
}
