#ifndef Log_h
#include "Log.h"
#endif

#ifndef StringUtilities_h
#include "StringUtilities.h"
#endif

#ifndef stdio_h
#include "stdio.h"
#endif

#ifndef stdarg_h
#define stdarg_h
#include <stdarg.h>
#endif

#ifndef std_algorithm
#define std_algorithm
#include <algorithm>
#endif

using namespace doctorj;

int Log::ALL = 0;

bool Log::allEnabled = false;

bool Log::allDisabled = false;

std::vector<int> Log::enabledIds;

std::vector<int> Log::disabledIds;

int Log::fileWidth = -40;

int Log::lineWidth = 5;

int Log::funcWidth = 80;

void Log::setEnabled(int id)
{
    if (id == ALL) {
        allEnabled = true;
    }
    else {
        enabledIds.push_back(id);
    }
}

void Log::setDisabled(int id)
{
    if (id == ALL) {
        allDisabled = true;
    }
    else {
        disabledIds.push_back(id);
    }
}

bool Log::isEnabled(int id)
{
    if (allEnabled) {
        // it might be explicitly disabled:
        return find(disabledIds.begin(), disabledIds.end(), id) == disabledIds.end();
    }
    else {
        // it must be explicitly enabled:
        return find(enabledIds.begin(), enabledIds.end(), id) != enabledIds.end();
    }
}

void Log::setWidths(int fileWidth, int lineWidth, int funcWidth)
{
    Log::fileWidth = fileWidth;
    Log::lineWidth = lineWidth;
    Log::funcWidth = funcWidth;
}

void Log::log(int id, const std::string& fileName, int line, const std::string& funcName, const std::string& msg)
{
    if (isEnabled(id)) {
        string func = funcName;
        // cout << "original func name: " << func << endl;
        
        StringUtilities::subst(&func, "doctorj::", "");

        // cout << "clean func name   : " << func << endl;

        int pos = func.find("::");
        if (pos != string::npos) {
            func = func.substr(pos + 2);
        }

        // cout << "clean func name   : " << func << endl;

        StringUtilities::subst(&func, " (", "(");

        int withpos = func.find(" [with");
        if (withpos != string::npos) {
            func = func.substr(0, withpos);
        }

        // cout << "clean func name   : " << func << endl;

        printf("[%*s:%*d] {%-*s} %s\n", fileWidth, fileName.c_str(), lineWidth, line, funcWidth, func.c_str(), msg.c_str());
    }
}

void Log::logfmt(int id, const std::string& fileName, int line, const std::string& funcName, const char* const fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    char msg[2048];             // JCU
    vsprintf(msg, fmt, ap);
    va_end(ap);

    log(id, fileName, line, funcName, msg);
}

