#ifndef Test_h
#include "Test.h"
#endif

#ifndef DebugOptions_h
#include "DebugOptions.h"
#endif

using namespace doctorj;
using namespace std;

class DebugOptionTest : public Test 
{
public:
    DebugOptionTest();
    virtual void run();
};


DebugOptionTest::DebugOptionTest() : Test(true)
{
}

void DebugOptionTest::run() 
{
    DebugOption a('a', "abcdefghijklmnopqrstuvyz");
    TESTEQ(a.getChar(), 'a', "the character");
    TESTEQ(a.getDescription(), "abcdefghijklmnopqrstuvyz", "the description");
    TESTEQ(a.getNumber(), -1, "the number, not yet assigned");
    a.setNumber(64);
    TESTEQ(a.getNumber(), 64, "the number, after being assigned");
}

int main(int argc, char** argv) 
{
    DebugOptionTest t;
    t.run();
    cout << "debug option test results: " << t << endl;
    return t.nerrors();
}
