#ifndef Test_h
#include "Test.h"
#endif

#ifndef StringEdit_h
#include "StringEdit.h"
#endif

#ifndef DebugOptions_h
#include "DebugOptions.h"
#endif

using namespace doctorj;

class EditableStringTest : public Test 
{
public:
    EditableStringTest();
    virtual void run();
};

EditableStringTest::EditableStringTest() : Test(true)
{
}

void EditableStringTest::run() 
{
    cout << "here I am" << endl;
    DebugOptions::get()->set("");
    cout << "and now I'm here" << endl;

    char* s = "abcdefghij";
    EditableString estr(s, s);
    estr.dump();

    estr.insert(3, "XYZ");
    estr.dump();

    estr.remove(7, 2);
    estr.dump();

    estr.replace(5, 2, "PQRS");
    estr.dump();

    estr.replace(9, 1, "01234");
    estr.dump();

    estr.insert(3, "hello");
    estr.dump();

    estr.move(1, 2, 4);
    estr.dump();

    cout << "test is done" << endl;
}

int main(int argc, char** argv) 
{
    EditableStringTest t;
    t.run();
    {
        cout << "editable string test results: " << t << endl;
    }
    return t.nerrors();
}
