#ifndef Test_h
#include "Test.h"
#endif

#ifndef StringEdit_h
#include "StringEdit.h"
#endif

using namespace doctorj;

class StringEditDeleteTest : public Test 
{
public:
    StringEditDeleteTest();
    virtual void run();
};

StringEditDeleteTest::StringEditDeleteTest() : Test(true)
{
}

void StringEditDeleteTest::run() 
{
    {
        //            012345678901234
        char*  str = "this is a test";
        char*  start = str;
        char*  end = str + strlen(str);
        char*  from = str + 8;
        char*  to = str + 9;
        char*  realpos = from;
        int    len = to - from;

        StringEditDelete del(from, to, start, end);

        TESTEQ((void*)realpos, (void*)del.position(), "delete position");
        TESTEQ(len, del.length(), "delete length");
    }

    {
        //            012345678901234
        char*  str = "this is a test";
        char*  start = str;
        char*  end = str + strlen(str);
        char*  from = str + 2;
        char*  to = str + 9;
        char*  realpos = from;
        int    len = to - from;

        StringEditDelete del(from, to, start, end);

        TESTEQ((void*)realpos, (void*)del.position(), "delete position");
        TESTEQ(len, del.length(), "delete length");
    }

    {
        //            012345678901234
        char*  str = "this is a test";
        char*  start = str;
        char*  end = str + strlen(str);
        char*  from = str + 12;
        char*  to = str + 188;  // nasty
        char*  realpos = from;
        int    len = end - from; // not to

        StringEditDelete del(from, to, start, end);

        TESTEQ((void*)realpos, (void*)del.position(), "delete position");
        TESTEQ(len, del.length(), "delete length");
    }

    {
        //            012345678901234
        char*  str = "this is a test";
        char*  start = str;
        char*  end = str + strlen(str);
        char*  from = str - 3456789; // vicious
        char*  to = str + 14;
        char*  realpos = str;
        int    len = to - start; // not from

        StringEditDelete del(from, to, start, end);

        TESTEQ((void*)realpos, (void*)del.position(), "delete position");
        TESTEQ(len, del.length(), "delete length");
    }
}

int main(int argc, char** argv) 
{
    StringEditDeleteTest t;
    t.run();
    cout << "string edit delete test results: " << t << endl;
    return t.nerrors();
}
