#ifndef Test_h
#include "Test.h"
#endif

#ifndef StringEdit_h
#include "StringEdit.h"
#endif

#ifndef DebugOptions_h
#include "DebugOptions.h"
#endif

using namespace doctorj;

class StringEditMoveTest : public Test 
{
public:
    StringEditMoveTest();
    virtual void run();
};

StringEditMoveTest::StringEditMoveTest() : Test(true)
{
}

void StringEditMoveTest::run() 
{
    DebugOptions::get()->set("");

    if (false) {
        char* c = "01234ABCD5678wxyz";
        StringEditor editor(c);
        editor.add(new StringEditMoveAfter(c + 4, 4, c + 12));
        editor.add(new StringEditMoveAfter(c + 8, 4, c + 0));
        editor.execute();
        cout << "editor.str() = '" << editor.str() << "'" << endl;
        for (int i = 0; i < strlen(c); ++i) {
            int idx = editor.index(c + i);
            cout << "index " << i << " (" << c[i] << ") = " << idx << endl;
        }
    }

    if (true) {
        char* c = "    /**\n"
            "     * @deprecated This is DEPRECATED.\n"
            "     * @see SomethingElse\n"
            "     * @since 6.6.44\n"
            "    */";
        StringEditor editor(c);
        editor.add(new StringEditMoveAfter(c + 15, 31, c + 79)); // deprecated -> since
        editor.add(new StringEditMoveAfter(c + 54, 18, c + 14)); // see -> deprecated
        editor.add(new StringEditMoveAfter(c + 80, 13, c + 53)); // since -> see
        editor.add(new StringEditReplace("abcdef", c + 35, 10)); // DEPRECATED -> abcdef
        editor.execute();
        cout << "editor.str() = '" << editor.str() << "'" << endl;
//         for (int i = 0; i < strlen(c); ++i) {
//             int idx = editor.index(c + i);
//             cout << "index " << i << " (" << c[i] << ") = " << idx << endl;
//         }
    }

#if 0
    if (true) {
        //         012345678901234
        char* c = "this is a test"; 
        
        StringEditor editor(c);
        editor.add(new StringEditMoveBefore(c + 10, 4, c + 5));
        editor.execute();
        cout << "editor.str() = '" << editor.str() << "'" << endl;
        TESTEQ("this testis a ", editor.str(), "execute after move");
    }

    if (true) {
        //         012345678901234
        char* c = "this is a test"; 

        StringEditor editor(c);
        editor.add(new StringEditMoveAfter(c + 5, 3, c + 10));
        editor.execute();
        cout << "editor.str() = '" << editor.str() << "'" << endl;
        TESTEQ("this a is test", editor.str(), "execute after move");

        int pos = editor.index(c + 6);
        cout << "SEMUT  index of c + 6: " << pos << endl;
    }

    if (true) {
        //         01234567890123
        char* c = "*abc *def *ghi";

        StringEditor editor(c);
        editor.add(new StringEditMoveAfter(c + 1, 3, c + 5));
        editor.add(new StringEditMoveAfter(c + 6, 3, c + 10));
        editor.add(new StringEditMoveAfter(c + 11, 3, c + 0));
        editor.execute();
        cout << "editor.str() = '" << editor.str() << "'" << endl;
        TESTEQ("*ghi *abc *def", editor.str(), "execute after move");
    }

    if (true) {
        //         0123456
        char* c = "*ab *de";

        StringEditor editor(c);
        editor.add(new StringEditMoveAfter(c + 1, 2, c + 4));
        editor.add(new StringEditMoveAfter(c + 5, 2, c + 0));
        editor.execute();
        cout << "editor.str() = '" << editor.str() << "'" << endl;
        TESTEQ("*de *ab", editor.str(), "execute after move");
    }
#endif
}

int main(int argc, char** argv) 
{
    StringEditMoveTest t;
    t.run();
    cout << "string edit move test results: " << t << endl;
    return t.nerrors();
}
