#ifndef Test_h
#include "Test.h"
#endif

#ifndef Yagol_h
#include "Yagol.h"
#endif

class YagolOptionListTest : public Test 
{
public:
    YagolOptionListTest();
    virtual void run();
};

YagolOptionListTest::YagolOptionListTest() : Test(true)
{
}

void YagolOptionListTest::run() 
{
    // variables and their default values
    string str1("defstr1");
    int int1(0);
    bool bool1(false);
    
    // option processor
    yagol::OptionList yagol;

    // valid options
    yagol.addOption("str1",  "String number one",  &str1);
    yagol.addOption("int1",  "Integer number one", &int1);
    yagol.addOption("bool1", "boolean number one", &bool1);
    
    // dump a usage statement, a la --help
    yagol.writeUsage(cout);

    {
        // pseudo command-line
        char* args[] = {
            "appname",
            "--str1", "string1",
            "--int1", "11",
            "--bool1"
        };
        const int NARGS = sizeof(args) / sizeof(args[0]);

        // process the command line
        try {
            yagol.process(NARGS, args);
        }
        catch (const yagol::Exception& e) {
            FAIL("exception thrown during processing");
        }

        // unprocessed arguments
        vector<char*> unproc = yagol.getUnprocessedArgs();

        // tests
        TESTEQ(unproc.size(), 0UL,       "should not have had any unprocessed arguments");
        TESTEQ(str1,          "string1", "processing of string one");
        TESTEQ(int1,          11,        "processing of integer one");
        TESTEQ(bool1,         true,      "processing of boolean one");
    }
}

int main(int argc, char** argv) 
{
    YagolOptionListTest t;
    t.run();
    cout << "yagol option list test results: " << t << endl;
    t.writeReport(cout);
    return t.nerrors();
}
