"""This module provides a simple way to compute the interpolation of
a Function (discrete or user-defined) onto a finite element space."""

# Copyright (C) 2009 Anders Logg
#
# This file is part of DOLFIN.
#
# DOLFIN is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# DOLFIN is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with DOLFIN.  If not, see <http://www.gnu.org/licenses/>.
#
# First added:  2009-08-29
# Last changed: 2011-01-22

__all__ = ["interpolate"]

# Local imports
import dolfin.cpp as cpp

from dolfin.functions.functionspace import FunctionSpaceBase
from dolfin.functions.function import Function

def interpolate(v, V):
    """Return interpolation of given Function v into the finite element space V.
    Example usage:

        V = FunctionSpace(mesh, "Lagrange", 1)

        Pv = interpolate(v, V)
    """

    # Check arguments
    if not isinstance(V, FunctionSpaceBase):
        cpp.error("Illegal function space for interpolation, not a FunctionSpace: " + str(v))

    # Compute interpolation
    Pv = Function(V)
    Pv.interpolate(v)

    return Pv
