__author__ = "Hans Petter Langtangen <hpl@simula.no>"
__date__ = "2009-12-14"
__copyright__ = "Copyright (C) 2009 " + __author__
__license__  = "GNU LGPL Version 2.1"

# Modified by Anders Logg, 2009.
# Last changed: 2010-02-14

class DoNothing(object):
    """
    This class is a generic dispatcher, accepting anyting and doing
    nothing. It can be used in places where certain functionality like
    plotting should be disabled without requiring changes to existing
    code.

    Whatever we do, we always get a DoNothing object, with which we can
    do whater we want to, but nothing will ever happen.
    """

    def __init__(self, *args, **kwargs):
        pass

    def __call__(self, *args, **kwargs):
        return DoNothing()

    def __repr__(self):
        return ""

    def __str__(self):
        return repr(self)

    def __getattribute__(self, name):
        print "Ignoring call to %s" % name
        return DoNothing()
