__author__ = "Marie E. Rognes (meg@simula.no)"
__copyright__ = "Copyright (C) 2010 Marie E. Rognes"
__license__  = "GNU GPL version 3 or any later version"

# Modified by Anders Logg, 2010.

# Last changed: 2010-06-22

__all__ = ["AdaptiveData"]

from dolfin import info
from dolfin.adaptivity.utils import print_value, print_value_green, print_value_red

class AdaptiveData:

    def __init__(self):

        self.refinement_level = 0
        self.functional_value = 0.0
        self.error_estimate = 0.0
        self.error_indicators = None
        self.sum_indicators = -1.0
        self.num_cells = 0
        self.num_dofs = 0
        self.reference = None

        self.t_primal = 0.0
        self.t_error_estimation = 0.0
        self.t_error_indicators = 0.0
        self.t_marking = 0.0
        self.t_refinement = 0.0
        self.t_marking = 0.0
        self.t_refinement = 0.0

    def summary(self):
        "Pretty-print summary"

        if self.reference is not None:
            actual_error = abs(self.reference - self.functional_value)
            index = self.error_estimate/actual_error
        else:
            actual_error, index = None, None

        info("")
        print_value("Refinement level   ", self.refinement_level)
        print_value("Value of functional", self.functional_value)
        print_value("Reference value    ", self.reference)
        print_value_green("Tolerance          ", self.tolerance)
        print_value_red("Error estimate     ", self.error_estimate)
        print_value("Actual error       ", actual_error)
        print_value("Effectivity index  ", index)
        print_value("Number of cells    ", self.num_cells)
        print_value("Number of dofs     ", self.num_dofs)
        info("")
        info("Timings/s")
        info("")
        print_value("Compute solution   ", self.t_primal)
        print_value("Estimate error     ", self.t_error_estimation)

        # Print only when nonzero
        if self.t_error_indicators > 0.0:
            print_value("Estimate error     ", self.t_error_estimation)
            print_value("Compute indicators ", self.t_error_indicators)
            print_value("Mark cells         ", self.t_marking)
            print_value("Refine mesh        ", self.t_refinement)

        info("")
