"""Expose names from the compiled cpp modules to the dolfin.cpp namespace"""

# Copyright (C) 2012 Johan Hake
#
# This file is part of DOLFIN.
#
# DOLFIN is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# DOLFIN is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
#
# First added:  2012-01-29
# Last changed: 2012-01-29


__all__ = []

#--- Imports the SWIG-generated Python code (C++ interface) ---

# NOTE: Order of these imports need to be preserved
_compiled_modules = ["common", "la", "function", "io", "mesh", "fem"]

# Prohibit includes with these names
_not_includes = _compiled_modules[:]
_not_includes.extend(["ufc", "new_instancemethod", "SHARED_PTR_DISOWN", \
                      "weakref", "weakref_proxy", "cvar"])

# Import all compiled modules
for module_name in _compiled_modules:

    # Import the module
    exec("import %s" % module_name)
    module = globals()[module_name]

    # Add the module to the global namespace
    __all__.append(module_name)

    # Collect all classes to outrule static class methods
    _all_classes = []

    # Iterate over the modules attributes and add names to global namespace
    for name in sorted(module.__dict__.keys()):

        # Skip some includes
        if name in _not_includes:
            continue

        # Do not add an attrbute name which contains "swigregister" or
        # starts with "_"
        if "swigregister" in name or name[0] == "_":
            continue

        # Get attr
        attr = getattr(module, name)

        # Check for class
        if isinstance(attr, type):
            _all_classes.append(name)
        else:
            # If not a class, check if first part of function name is the
            # same as a class name
            if name.split("_")[0] in _all_classes:
                continue
        
        # Add the attribute to the global namespace
        globals()[name] = attr
        __all__.append(name)

# Add version 
# -----------
globals()["__version__"] = getattr(module, "__dolfinversion__")
globals()["__swigversion__"] = getattr(module, "__swigversion__")
